/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import de.aservo.confapi.crowd.model.SessionConfigBean;
import de.aservo.confapi.crowd.service.api.SessionConfigService;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SessionConfigService.class})
public class SessionConfigServiceImpl
implements SessionConfigService {
    private final PropertyManager propertyManager;

    @Inject
    public SessionConfigServiceImpl(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    @Override
    public SessionConfigBean getSessionConfig() {
        SessionConfigBean sessionConfigBean = new SessionConfigBean();
        sessionConfigBean.setSessionTimeoutInMinutes(this.propertyManager.getSessionTime());
        sessionConfigBean.setRequireConsistentClientIP(this.propertyManager.isIncludeIpAddressInValidationFactors());
        return sessionConfigBean;
    }

    @Override
    public SessionConfigBean setSessionConfig(SessionConfigBean sessionConfigBean) {
        if (sessionConfigBean.getSessionTimeoutInMinutes() != null) {
            this.propertyManager.setSessionTime(sessionConfigBean.getSessionTimeoutInMinutes().longValue());
        }
        if (sessionConfigBean.getRequireConsistentClientIP() != null) {
            this.propertyManager.setIncludeIpAddressInValidationFactors(sessionConfigBean.getRequireConsistentClientIP().booleanValue());
        }
        return this.getSessionConfig();
    }
}

