/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.model.GroupBean;
import de.aservo.confapi.crowd.exception.NotFoundExceptionForDirectory;
import de.aservo.confapi.crowd.exception.NotFoundExceptionForGroup;
import de.aservo.confapi.crowd.model.GroupsBean;
import de.aservo.confapi.crowd.model.util.GroupBeanUtil;
import de.aservo.confapi.crowd.service.api.GroupsService;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={GroupsService.class})
public class GroupsServiceImpl
implements GroupsService {
    @ComponentImport
    private final DirectoryManager directoryManager;

    @Inject
    public GroupsServiceImpl(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Override
    public GroupBean getGroup(long directoryId, String groupName) {
        Group group = this.findGroup(directoryId, groupName);
        if (group == null) {
            throw new NotFoundExceptionForGroup(groupName);
        }
        return GroupBeanUtil.toGroupBean(group);
    }

    @Override
    public GroupBean createGroup(long directoryId, GroupBean groupBean) {
        if (groupBean.getName() == null) {
            throw new BadRequestException("Cannot create group, group name is required");
        }
        Group existingGroup = this.findGroup(directoryId, groupBean.getName());
        if (existingGroup != null) {
            throw new BadRequestException(String.format("Group '%s' already exists", groupBean.getName()));
        }
        GroupTemplate groupTemplate = new GroupTemplate(groupBean.getName(), directoryId);
        groupTemplate.setDescription(groupBean.getDescription());
        groupTemplate.setActive(groupBean.getActive() == null || groupBean.getActive() != false);
        try {
            return GroupBeanUtil.toGroupBean(this.directoryManager.addGroup(directoryId, groupTemplate));
        }
        catch (InvalidGroupException | DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public GroupBean updateGroup(long directoryId, String groupName, GroupBean groupBean) {
        Group group = this.findGroup(directoryId, groupName);
        if (group == null) {
            throw new NotFoundExceptionForGroup(groupName);
        }
        if (groupBean.getName() != null && !groupBean.getName().equals(group.getName())) {
            group = this.renameGroup(directoryId, groupName, groupBean.getName());
        }
        if (groupBean.getDescription() != null || groupBean.getActive() != null) {
            group = this.updateGroup(directoryId, this.createGroupTemplate(group, groupBean));
        }
        return GroupBeanUtil.toGroupBean(group);
    }

    @Override
    public GroupBean setGroup(long directoryId, String groupName, GroupBean groupBean) {
        Group group = this.findGroup(directoryId, groupName);
        if (group == null) {
            return this.createGroup(directoryId, groupBean);
        }
        return this.updateGroup(directoryId, groupName, groupBean);
    }

    @Override
    public GroupsBean setGroups(long directoryId, GroupsBean groupsBean) {
        if (groupsBean == null || groupsBean.getGroups() == null) {
            return new GroupsBean(Collections.emptyList());
        }
        return new GroupsBean(groupsBean.getGroups().stream().map(groupBean -> this.setGroup(directoryId, groupBean.getName(), (GroupBean)groupBean)).collect(Collectors.toList()));
    }

    @Nullable
    Group findGroup(long directoryId, String groupName) {
        try {
            return this.directoryManager.findGroupByName(directoryId, groupName);
        }
        catch (DirectoryNotFoundException e) {
            throw new NotFoundExceptionForDirectory(directoryId);
        }
        catch (GroupNotFoundException e) {
        }
        catch (OperationFailedException e) {
            throw new InternalServerErrorException(e);
        }
        return null;
    }

    Group updateGroup(long directoryId, GroupTemplate groupTemplate) {
        try {
            return this.directoryManager.updateGroup(directoryId, groupTemplate);
        }
        catch (InvalidGroupException | ReadOnlyGroupException | DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            throw new InternalServerErrorException(e);
        }
    }

    Group renameGroup(long directoryId, String currentGroupName, String newGroupName) {
        try {
            return this.directoryManager.renameGroup(directoryId, currentGroupName, newGroupName);
        }
        catch (InvalidGroupException | DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            throw new InternalServerErrorException(e);
        }
    }

    GroupTemplate createGroupTemplate(Group group, GroupBean groupBean) {
        GroupTemplate groupTemplate = new GroupTemplate(group);
        if (groupBean.getDescription() != null) {
            groupTemplate.setDescription(groupBean.getDescription());
        }
        if (groupBean.getActive() != null) {
            groupTemplate.setActive(groupBean.getActive().booleanValue());
        }
        return groupTemplate;
    }
}

