/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.bitbucket.BitbucketApplicationType;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.application.crowd.CrowdApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.core.ApplinkStatus;
import com.atlassian.applinks.core.ApplinkStatusService;
import com.atlassian.applinks.internal.common.exception.NoAccessException;
import com.atlassian.applinks.internal.common.exception.NoSuchApplinkException;
import com.atlassian.applinks.internal.status.error.ApplinkErrorType;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationScenario;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.NotFoundException;
import de.aservo.confapi.commons.model.ApplicationLinkBean;
import de.aservo.confapi.commons.model.ApplicationLinksBean;
import de.aservo.confapi.commons.service.api.ApplicationLinksService;
import de.aservo.confapi.crowd.model.DefaultAuthenticationScenario;
import de.aservo.confapi.crowd.model.util.ApplicationLinkBeanUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService(value={ApplicationLinksService.class})
public class ApplicationLinksServiceImpl
implements ApplicationLinksService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinksServiceImpl.class);
    private final MutatingApplicationLinkService mutatingApplicationLinkService;
    private final TypeAccessor typeAccessor;
    private final ApplinkStatusService applinkStatusService;

    @Inject
    public ApplicationLinksServiceImpl(@ComponentImport MutatingApplicationLinkService mutatingApplicationLinkService, @ComponentImport TypeAccessor typeAccessor, @ComponentImport ApplinkStatusService applinkStatusService) {
        this.mutatingApplicationLinkService = mutatingApplicationLinkService;
        this.typeAccessor = typeAccessor;
        this.applinkStatusService = applinkStatusService;
    }

    @Override
    public ApplicationLinksBean getApplicationLinks() {
        Iterable applicationLinksIterable = this.mutatingApplicationLinkService.getApplicationLinks();
        List<ApplicationLinkBean> applicationLinkBeans = StreamSupport.stream(applicationLinksIterable.spliterator(), false).map(this::getApplicationLinkBeanWithStatus).collect(Collectors.toList());
        return new ApplicationLinksBean(applicationLinkBeans);
    }

    @Override
    public ApplicationLinkBean getApplicationLink(UUID uuid) {
        try {
            MutableApplicationLink applicationLink = (MutableApplicationLink)this.findApplicationLink(uuid);
            return this.getApplicationLinkBeanWithStatus((ApplicationLink)applicationLink);
        }
        catch (TypeNotInstalledException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @Override
    public ApplicationLinksBean setApplicationLinks(@NotNull ApplicationLinksBean applicationLinksBean, boolean ignoreSetupErrors) {
        Map applicationLinksByRpcUrl = this.getApplicationLinks().getApplicationLinks().stream().collect(Collectors.toMap(ApplicationLinkBean::getRpcUrl, Function.identity()));
        for (ApplicationLinkBean applicationLink : applicationLinksBean.getApplicationLinks()) {
            if (applicationLinksByRpcUrl.containsKey(applicationLink.getRpcUrl())) {
                this.setApplicationLink(applicationLink.getUuid(), applicationLink, ignoreSetupErrors);
                continue;
            }
            this.addApplicationLink(applicationLink, ignoreSetupErrors);
        }
        return this.getApplicationLinks();
    }

    @Override
    public ApplicationLinkBean setApplicationLink(@NotNull UUID uuid, @NotNull ApplicationLinkBean applicationLinkBean, boolean ignoreSetupErrors) {
        ApplicationId id = new ApplicationId(uuid.toString());
        try {
            ApplicationLink applicationLink = this.findApplicationLink(uuid);
            this.mutatingApplicationLinkService.deleteApplicationLink(applicationLink);
            ApplicationLinkDetails linkDetails = ApplicationLinkBeanUtil.toApplicationLinkDetails(applicationLinkBean);
            ApplicationType applicationType = this.buildApplicationType(applicationLinkBean.getType());
            MutableApplicationLink mutableApplicationLink = this.mutatingApplicationLinkService.addApplicationLink(id, applicationType, linkDetails);
            return this.getApplicationLinkBeanWithStatus((ApplicationLink)mutableApplicationLink);
        }
        catch (TypeNotInstalledException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @Override
    public ApplicationLinkBean addApplicationLink(@NotNull ApplicationLinkBean applicationLinkBean, boolean ignoreSetupErrors) {
        ApplicationLink applicationLink;
        block5: {
            ApplicationLinkDetails linkDetails = ApplicationLinkBeanUtil.toApplicationLinkDetails(applicationLinkBean);
            ApplicationType applicationType = this.buildApplicationType(applicationLinkBean.getType());
            Class<?> appType = applicationType != null ? applicationType.getClass() : null;
            ApplicationLink primaryApplicationLink = this.mutatingApplicationLinkService.getPrimaryApplicationLink(appType);
            if (primaryApplicationLink != null) {
                log.info("An existing application link configuration '{}' was found and is removed now before adding the new configuration", (Object)primaryApplicationLink.getName());
                this.mutatingApplicationLinkService.deleteApplicationLink(primaryApplicationLink);
            }
            try {
                applicationLink = this.mutatingApplicationLinkService.createApplicationLink(applicationType, linkDetails);
            }
            catch (ManifestNotFoundException e) {
                throw new BadRequestException(e.getMessage());
            }
            try {
                this.mutatingApplicationLinkService.configureAuthenticationForApplicationLink(applicationLink, (AuthenticationScenario)new DefaultAuthenticationScenario(), applicationLinkBean.getUsername(), applicationLinkBean.getPassword());
            }
            catch (AuthenticationConfigurationException e) {
                if (ignoreSetupErrors) break block5;
                throw new BadRequestException(e.getMessage());
            }
        }
        return this.getApplicationLinkBeanWithStatus(applicationLink);
    }

    @Override
    public void deleteApplicationLinks(boolean force) {
        if (!force) {
            throw new BadRequestException("'force = true' must be supplied to delete all entries");
        }
        for (ApplicationLink applicationLink : this.mutatingApplicationLinkService.getApplicationLinks()) {
            this.mutatingApplicationLinkService.deleteApplicationLink(applicationLink);
        }
    }

    @Override
    public void deleteApplicationLink(@NotNull UUID uuid) {
        try {
            MutableApplicationLink applicationLink = (MutableApplicationLink)this.findApplicationLink(uuid);
            this.mutatingApplicationLinkService.deleteApplicationLink((ApplicationLink)applicationLink);
        }
        catch (TypeNotInstalledException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private ApplicationType buildApplicationType(ApplicationLinkBean.ApplicationLinkType linkType) {
        switch (linkType) {
            case BAMBOO: {
                return this.typeAccessor.getApplicationType(BambooApplicationType.class);
            }
            case JIRA: {
                return this.typeAccessor.getApplicationType(JiraApplicationType.class);
            }
            case BITBUCKET: {
                return this.typeAccessor.getApplicationType(BitbucketApplicationType.class);
            }
            case CONFLUENCE: {
                return this.typeAccessor.getApplicationType(ConfluenceApplicationType.class);
            }
            case FISHEYE: {
                return this.typeAccessor.getApplicationType(FishEyeCrucibleApplicationType.class);
            }
            case CROWD: {
                return this.typeAccessor.getApplicationType(CrowdApplicationType.class);
            }
        }
        throw new NotImplementedException("application type '" + (Object)((Object)linkType) + "' not implemented");
    }

    private ApplicationLink findApplicationLink(UUID uuid) throws TypeNotInstalledException {
        MutableApplicationLink applicationLink = this.mutatingApplicationLinkService.getApplicationLink(new ApplicationId(uuid.toString()));
        if (applicationLink == null) {
            throw new NotFoundException("ApplicationLink with id " + uuid.toString() + " not found.");
        }
        return applicationLink;
    }

    private ApplicationLinkBean getApplicationLinkBeanWithStatus(ApplicationLink applicationLink) {
        ApplicationLinkBean applicationLinkBean = ApplicationLinkBeanUtil.toApplicationLinkBean(applicationLink);
        try {
            ApplinkStatus applinkStatus = this.applinkStatusService.getApplinkStatus(applicationLink.getId());
            if (applinkStatus.isWorking()) {
                applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.AVAILABLE);
            } else if (applinkStatus.getError() != null && ApplinkErrorType.CONNECTION_REFUSED.equals((Object)applinkStatus.getError().getType())) {
                applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.UNAVAILABLE);
            } else {
                applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.CONFIGURATION_ERROR);
            }
        }
        catch (NoAccessException | NoSuchApplinkException e) {
            applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.CONFIGURATION_ERROR);
        }
        return applicationLinkBean;
    }
}

