/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.rest;

import com.sun.jersey.spi.container.ResourceFilters;
import de.aservo.confapi.commons.model.MailServerSmtpBean;
import de.aservo.confapi.commons.rest.api.MailServerSmtpResource;
import de.aservo.confapi.commons.service.api.MailServerService;
import de.aservo.confapi.crowd.filter.SysadminOnlyResourceFilter;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="mail-server")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@Component
public class MailServerResourceImpl
implements MailServerSmtpResource {
    private final MailServerService mailServerService;

    @Inject
    public MailServerResourceImpl(MailServerService mailServerService) {
        this.mailServerService = mailServerService;
    }

    @Override
    public Response getMailServerSmtp() {
        MailServerSmtpBean smtpBean = this.mailServerService.getMailServerSmtp();
        if (smtpBean == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)smtpBean).build();
    }

    @Override
    public Response setMailServerSmtp(MailServerSmtpBean bean) {
        MailServerSmtpBean updatedSmtpBean = this.mailServerService.setMailServerSmtp(bean);
        return Response.ok((Object)updatedSmtpBean).build();
    }
}

