/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.util;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BeanValidationUtil {
    public static void validate(Object bean) {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        BeanValidationUtil.processValidationResult(validator.validate(bean, new Class[0]));
    }

    public static void processValidationResult(Set<ConstraintViolation<Object>> violations) {
        if (!violations.isEmpty()) {
            List collect = violations.stream().map(v -> v.getPropertyPath() + ": " + v.getMessage()).collect(Collectors.toList());
            throw new ValidationException(String.join((CharSequence)"\n", collect));
        }
    }

    private BeanValidationUtil() {
    }
}

