/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest;

import com.google.common.base.Preconditions;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoriesBean;
import de.aservo.confapi.commons.rest.api.DirectoriesResource;
import de.aservo.confapi.commons.service.api.DirectoriesService;
import javax.ws.rs.core.Response;

public abstract class AbstractDirectoriesResourceImpl
implements DirectoriesResource {
    private final DirectoriesService directoriesService;

    public AbstractDirectoriesResourceImpl(DirectoriesService directoriesService) {
        this.directoriesService = (DirectoriesService)Preconditions.checkNotNull((Object)directoriesService);
    }

    @Override
    public Response getDirectories() {
        DirectoriesBean directoriesBean = this.directoriesService.getDirectories();
        return Response.ok((Object)directoriesBean).build();
    }

    @Override
    public Response getDirectory(long id) {
        AbstractDirectoryBean directoryBean = this.directoriesService.getDirectory(id);
        return Response.ok((Object)directoryBean).build();
    }

    @Override
    public Response setDirectories(boolean testConnection, DirectoriesBean directories) {
        DirectoriesBean directoriesBean = this.directoriesService.setDirectories(directories, testConnection);
        return Response.ok((Object)directoriesBean).build();
    }

    @Override
    public Response setDirectory(long id, boolean testConnection, AbstractDirectoryBean directory) {
        AbstractDirectoryBean directoriesBean = this.directoriesService.setDirectory(id, directory, testConnection);
        return Response.ok((Object)directoriesBean).build();
    }

    @Override
    public Response addDirectory(boolean testConnection, AbstractDirectoryBean directory) {
        AbstractDirectoryBean addedDirectoryBean = this.directoriesService.addDirectory(directory, testConnection);
        return Response.ok((Object)addedDirectoryBean).build();
    }

    @Override
    public Response deleteDirectories(boolean force) {
        this.directoriesService.deleteDirectories(force);
        return Response.ok().build();
    }

    @Override
    public Response deleteDirectory(long id) {
        this.directoriesService.deleteDirectory(id);
        return Response.ok().build();
    }
}

