/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.ApplicationLinkBean;
import de.aservo.confapi.commons.model.ApplicationLinksBean;
import de.aservo.confapi.commons.rest.api.ApplicationLinksResource;
import de.aservo.confapi.commons.service.api.ApplicationLinksService;
import java.util.UUID;
import javax.ws.rs.core.Response;

public abstract class AbstractApplicationLinksResourceImpl
implements ApplicationLinksResource {
    private final ApplicationLinksService applicationLinksService;

    public AbstractApplicationLinksResourceImpl(ApplicationLinksService applicationLinksService) {
        this.applicationLinksService = applicationLinksService;
    }

    @Override
    public Response getApplicationLinks() {
        ApplicationLinksBean linksBean = this.applicationLinksService.getApplicationLinks();
        return Response.ok((Object)linksBean).build();
    }

    @Override
    public Response getApplicationLink(UUID uuid) {
        ApplicationLinkBean linkBean = this.applicationLinksService.getApplicationLink(uuid);
        return Response.ok((Object)linkBean).build();
    }

    @Override
    public Response setApplicationLinks(boolean ignoreSetupErrors, ApplicationLinksBean linksBean) {
        ApplicationLinksBean updatedLinksBean = this.applicationLinksService.setApplicationLinks(linksBean, ignoreSetupErrors);
        return Response.ok((Object)updatedLinksBean).build();
    }

    @Override
    public Response setApplicationLink(UUID uuid, boolean ignoreSetupErrors, ApplicationLinkBean linkBean) {
        ApplicationLinkBean updatedLinkBean = this.applicationLinksService.setApplicationLink(uuid, linkBean, ignoreSetupErrors);
        return Response.ok((Object)updatedLinkBean).build();
    }

    @Override
    public Response addApplicationLink(boolean ignoreSetupErrors, ApplicationLinkBean linkBean) {
        ApplicationLinkBean addedApplicationLink = this.applicationLinksService.addApplicationLink(linkBean, ignoreSetupErrors);
        return Response.ok((Object)addedApplicationLink).build();
    }

    @Override
    public Response deleteApplicationLinks(boolean force) {
        this.applicationLinksService.deleteApplicationLinks(force);
        return Response.ok().build();
    }

    @Override
    public Response deleteApplicationLink(UUID uuid) {
        this.applicationLinksService.deleteApplicationLink(uuid);
        return Response.ok().build();
    }
}

