/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="error")
public class ErrorCollection {
    @XmlElement
    private final Collection<String> errorMessages = new ArrayList<String>();

    public ErrorCollection addErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            this.errorMessages.add(errorMessage);
        }
        return this;
    }

    public ErrorCollection addErrorMessages(Collection<String> messages) {
        if (messages != null) {
            messages.forEach(this::addErrorMessage);
        }
        return this;
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty();
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public static ErrorCollection of(String ... messages) {
        return ErrorCollection.of(Arrays.asList(messages));
    }

    public static ErrorCollection of(Collection<String> messages) {
        return new ErrorCollection().addErrorMessages(messages);
    }
}

