/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.model.GroupBean;
import de.aservo.confapi.commons.model.UserBean;
import de.aservo.confapi.commons.service.api.UsersService;
import de.aservo.confapi.crowd.exception.NotFoundExceptionForDirectory;
import de.aservo.confapi.crowd.exception.NotFoundExceptionForUser;
import de.aservo.confapi.crowd.model.GroupsBean;
import de.aservo.confapi.crowd.model.util.UserBeanUtil;
import de.aservo.confapi.crowd.service.api.GroupsService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={UsersService.class})
public class UsersServiceImpl
implements UsersService {
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final DirectoryManager directoryManager;
    private final GroupsService groupsService;

    @Inject
    public UsersServiceImpl(CrowdService crowdService, DirectoryManager directoryManager, GroupsService groupsService) {
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.groupsService = groupsService;
    }

    @Override
    public UserBean getUser(long directoryId, String username) {
        com.atlassian.crowd.model.user.User user = this.findUser(directoryId, username);
        if (user == null) {
            throw new NotFoundExceptionForUser(username);
        }
        return UserBeanUtil.toUserBean(user);
    }

    @Override
    public UserBean setUser(long directoryId, UserBean userBean) {
        com.atlassian.crowd.model.user.User user = this.findUser(directoryId, userBean.getUsername());
        if (user == null) {
            return this.addUser(directoryId, userBean);
        }
        return this.updateUser(directoryId, user.getName(), userBean);
    }

    @Override
    public List<UserBean> setUsers(long directoryId, Collection<UserBean> userBeans) {
        if (userBeans == null) {
            return Collections.emptyList();
        }
        return userBeans.stream().map(userBean -> this.setUser(directoryId, (UserBean)userBean)).collect(Collectors.toList());
    }

    public UserBean addUser(long directoryId, UserBean userBean) {
        return this.addUser(directoryId, userBean.getUsername(), userBean);
    }

    UserBean addUser(long directoryId, String username, UserBean userBean) {
        com.atlassian.crowd.model.user.User existingUser = this.findUser(directoryId, userBean.getUsername());
        if (existingUser != null) {
            throw new BadRequestException(String.format("User '%s' already exists", userBean.getUsername()));
        }
        if (userBean.getUsername() == null) {
            if (username == null) {
                throw new BadRequestException("Cannot create user, username is required");
            }
            userBean.setUsername(username);
        }
        if (username != null && !userBean.getUsername().equals(username)) {
            throw new BadRequestException("Cannot create user, two different usernames provided");
        }
        if (userBean.getFirstName() == null || userBean.getLastName() == null || userBean.getFullName() == null || userBean.getEmail() == null) {
            throw new BadRequestException("Cannot create user, first name, last name, display (full) name and email are required");
        }
        if (userBean.getPassword() == null) {
            throw new BadRequestException("Cannot create user, password is required");
        }
        UserTemplateWithAttributes userTemplate = new UserTemplateWithAttributes(userBean.getUsername(), directoryId);
        userTemplate.setFirstName(userBean.getFirstName());
        userTemplate.setLastName(userBean.getLastName());
        userTemplate.setDisplayName(userBean.getFullName());
        userTemplate.setEmailAddress(userBean.getEmail());
        userTemplate.setActive(userBean.getActive() == null || userBean.getActive() != false);
        com.atlassian.crowd.model.user.User user = this.createUser(directoryId, userTemplate, userBean.getPassword());
        UserBean resultUserBean = UserBeanUtil.toUserBean(user);
        if (userBean.getGroups() != null) {
            GroupsBean resultGroupsBean = this.addUserToGroups(directoryId, userBean.getUsername(), userBean.getGroups());
            resultUserBean.setGroups(resultGroupsBean.getGroups());
        }
        return resultUserBean;
    }

    UserBean updateUser(long directoryId, String username, UserBean userBean) {
        com.atlassian.crowd.model.user.User user = this.findUser(directoryId, username);
        if (user == null) {
            throw new NotFoundExceptionForUser(username);
        }
        if (userBean.getUsername() != null && !username.equals(userBean.getUsername())) {
            user = this.renameUser(user, userBean.getUsername());
        }
        if (userBean.getFirstName() != null || userBean.getLastName() != null || userBean.getFullName() != null || userBean.getEmail() != null) {
            user = this.updateUser(user.getDirectoryId(), UsersServiceImpl.getUserTemplate(user, userBean));
        }
        if (userBean.getPassword() != null) {
            this.updatePassword(user, userBean.getPassword());
        }
        UserBean resultUserBean = UserBeanUtil.toUserBean(user);
        if (userBean.getGroups() != null) {
            GroupsBean resultGroupsBean = this.addUserToGroups(directoryId, userBean.getUsername(), userBean.getGroups());
            resultUserBean.setGroups(resultGroupsBean.getGroups());
        }
        return resultUserBean;
    }

    @Nullable
    com.atlassian.crowd.model.user.User findUser(long directoryId, String username) {
        try {
            return this.directoryManager.findUserByName(directoryId, username);
        }
        catch (DirectoryNotFoundException e) {
            throw new NotFoundExceptionForDirectory(directoryId);
        }
        catch (UserNotFoundException e) {
        }
        catch (OperationFailedException e) {
            throw new InternalServerErrorException(e);
        }
        return null;
    }

    @Override
    @Deprecated
    public UserBean getUser(String username) {
        com.atlassian.crowd.model.user.User user = this.findUserAllDirectories(username);
        if (user == null) {
            throw new NotFoundExceptionForUser(username);
        }
        return UserBeanUtil.toUserBean(user);
    }

    @Override
    @Deprecated
    public UserBean updateUser(String username, UserBean userBean) {
        com.atlassian.crowd.model.user.User user = this.findUserAllDirectories(username);
        if (user == null) {
            throw new NotFoundExceptionForUser(username);
        }
        return this.updateUser(user.getDirectoryId(), username, userBean);
    }

    @Override
    @Deprecated
    public UserBean updatePassword(String username, String password) {
        com.atlassian.crowd.model.user.User user = this.findUserAllDirectories(username);
        if (user == null) {
            throw new NotFoundExceptionForUser(username);
        }
        this.updatePassword(user, password);
        return UserBeanUtil.toUserBean(user);
    }

    @Nullable
    @Deprecated
    private com.atlassian.crowd.model.user.User findUserAllDirectories(String username) {
        for (Directory directory : this.findDirectories()) {
            try {
                return this.directoryManager.findUserByName(directory.getId().longValue(), username);
            }
            catch (UserNotFoundException userNotFoundException) {
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                throw new InternalServerErrorException(e);
            }
        }
        return null;
    }

    @NotNull
    private com.atlassian.crowd.model.user.User renameUser(com.atlassian.crowd.model.user.User user, String newUsername) {
        try {
            return this.directoryManager.renameUser(user.getDirectoryId(), user.getName(), newUsername);
        }
        catch (InvalidUserException | UserAlreadyExistsException | DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new InternalServerErrorException(e);
        }
    }

    @NotNull
    private com.atlassian.crowd.model.user.User createUser(long directoryId, UserTemplateWithAttributes userTemplate, String password) {
        PasswordCredential passwordCredential = PasswordCredential.unencrypted((String)password);
        try {
            return this.directoryManager.addUser(directoryId, userTemplate, passwordCredential);
        }
        catch (InvalidCredentialException | InvalidUserException | UserAlreadyExistsException | DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new InternalServerErrorException(e);
        }
    }

    @NotNull
    private com.atlassian.crowd.model.user.User updateUser(long directoryId, UserTemplate userTemplate) {
        try {
            return this.directoryManager.updateUser(directoryId, userTemplate);
        }
        catch (InvalidUserException | DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new InternalServerErrorException(e);
        }
    }

    void updatePassword(com.atlassian.crowd.model.user.User user, String password) {
        this.resetUserPasswordAttributes(user);
        try {
            User authenticatedUser = this.crowdService.authenticate(user.getName(), password);
            if (authenticatedUser != null) {
                return;
            }
        }
        catch (FailedAuthenticationException authenticatedUser) {
            // empty catch block
        }
        try {
            this.directoryManager.updateUserCredential(user.getDirectoryId(), user.getName(), PasswordCredential.unencrypted((String)password));
        }
        catch (InvalidCredentialException | DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new InternalServerErrorException(e);
        }
    }

    void resetUserPasswordAttributes(com.atlassian.crowd.model.user.User user) {
        UserTemplateWithAttributes userTemplate = UserTemplateWithAttributes.toUserWithNoAttributes((com.atlassian.crowd.model.user.User)user);
        userTemplate.setAttribute("invalidPasswordAttempts", String.valueOf(0));
        userTemplate.setAttribute("requiresPasswordChange", String.valueOf(false));
        userTemplate.setAttribute("passwordLastChanged", String.valueOf(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        try {
            this.directoryManager.updateUser(user.getDirectoryId(), (UserTemplate)userTemplate);
        }
        catch (DirectoryPermissionException e) {
            throw new BadRequestException(e);
        }
        catch (DirectoryNotFoundException | InvalidUserException | OperationFailedException | UserNotFoundException e) {
            throw new InternalServerErrorException(e);
        }
    }

    GroupsBean addUserToGroups(long directoryId, String username, Collection<GroupBean> groupBeans) {
        ArrayList<GroupBean> resultGroupBeans = new ArrayList<GroupBean>();
        if (groupBeans != null) {
            for (GroupBean groupBean : groupBeans) {
                GroupBean resultGroupBean = this.groupsService.setGroup(directoryId, groupBean.getName(), groupBean);
                try {
                    this.directoryManager.addUserToGroup(directoryId, username, groupBean.getName());
                    resultGroupBeans.add(resultGroupBean);
                }
                catch (ReadOnlyGroupException | DirectoryPermissionException e) {
                    throw new BadRequestException(e);
                }
                catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | UserNotFoundException e) {
                    throw new InternalServerErrorException(e);
                }
                catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
                }
            }
        }
        return new GroupsBean(resultGroupBeans);
    }

    private static UserTemplate getUserTemplate(com.atlassian.crowd.model.user.User user, UserBean userBean) {
        UserTemplate userTemplate = new UserTemplate(user);
        if (userBean.getFirstName() != null) {
            userTemplate.setFirstName(userBean.getFirstName());
        }
        if (userBean.getLastName() != null) {
            userTemplate.setLastName(userBean.getLastName());
        }
        if (userBean.getFullName() != null) {
            userTemplate.setDisplayName(userBean.getFullName());
        }
        if (userBean.getEmail() != null) {
            userTemplate.setEmailAddress(userBean.getEmail());
        }
        if (userBean.getActive() != null) {
            userTemplate.setActive(userBean.getActive().booleanValue());
        }
        return userTemplate;
    }

    @Deprecated
    private List<Directory> findDirectories() {
        EntityQuery directoryEntityQuery = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1);
        return this.directoryManager.searchDirectories(directoryEntityQuery);
    }
}

