/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.rest.api;

import de.aservo.confapi.commons.http.PATCH;
import de.aservo.confapi.commons.model.ErrorCollection;
import de.aservo.confapi.commons.model.GroupBean;
import de.aservo.confapi.crowd.model.GroupsBean;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface GroupsResource {
    @GET
    @Produces(value={"application/json"})
    @Operation(tags={"groups"}, summary="Get a group", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GroupBean.class))}, description="Returns the requested group details"), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getGroup(@NotNull @QueryParam(value="directoryId") long var1, @NotNull @QueryParam(value="name") String var3);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"groups"}, summary="Create a group", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GroupBean.class))}, description="Returns the updated group details"), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response createGroup(@NotNull @QueryParam(value="directoryId") long var1, @NotNull GroupBean var3);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"groups"}, summary="Update a group", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GroupBean.class))}, description="Returns the updated group details"), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response updateGroup(@NotNull @QueryParam(value="directoryId") long var1, @NotNull @QueryParam(value="name") String var3, @NotNull GroupBean var4);

    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"groups"}, summary="Set groups", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GroupBean.class))}, description="Returns the updated groups details"), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setGroups(@NotNull @QueryParam(value="directoryId") long var1, @NotNull GroupsBean var3);
}

