/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.model.util;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import de.aservo.confapi.crowd.model.ApplicationBean;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class ApplicationBeanUtil {
    public static ApplicationBean toApplicationBean(Application application) {
        ApplicationBean applicationBean = new ApplicationBean();
        applicationBean.setId(application.getId());
        applicationBean.setName(application.getName());
        applicationBean.setDescription(application.getDescription());
        applicationBean.setActive(application.isActive());
        applicationBean.setType(ApplicationBeanUtil.toApplicationBeanType(application.getType()));
        applicationBean.setRemoteAddresses(ApplicationBeanUtil.toStringCollection(application.getRemoteAddresses()));
        return applicationBean;
    }

    public static Application toApplication(ApplicationBean applicationBean) {
        return ImmutableApplication.builder((String)applicationBean.getName(), (ApplicationType)ApplicationBeanUtil.toApplicationType(applicationBean.getType())).setDescription(applicationBean.getDescription()).setActive(applicationBean.getActive().booleanValue()).setPasswordCredential(PasswordCredential.unencrypted((String)applicationBean.getPassword())).setRemoteAddresses(ApplicationBeanUtil.toAddressSet(applicationBean.getRemoteAddresses())).build();
    }

    @Nullable
    public static ApplicationBean.ApplicationType toApplicationBeanType(ApplicationType applicationType) {
        if (ApplicationType.GENERIC_APPLICATION.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.GENERIC;
        }
        if (ApplicationType.PLUGIN.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.PLUGIN;
        }
        if (ApplicationType.CROWD.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.CROWD;
        }
        if (ApplicationType.JIRA.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.JIRA;
        }
        if (ApplicationType.CONFLUENCE.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.CONFLUENCE;
        }
        if (ApplicationType.STASH.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.BITBUCKET;
        }
        if (ApplicationType.FISHEYE.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.FISHEYE;
        }
        if (ApplicationType.CRUCIBLE.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.CRUCIBLE;
        }
        if (ApplicationType.BAMBOO.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.BAMBOO;
        }
        return null;
    }

    @Nullable
    public static ApplicationType toApplicationType(ApplicationBean.ApplicationType applicationBeanType) {
        if (ApplicationBean.ApplicationType.GENERIC.equals((Object)applicationBeanType)) {
            return ApplicationType.GENERIC_APPLICATION;
        }
        if (ApplicationBean.ApplicationType.PLUGIN.equals((Object)applicationBeanType)) {
            return ApplicationType.PLUGIN;
        }
        if (ApplicationBean.ApplicationType.CROWD.equals((Object)applicationBeanType)) {
            return ApplicationType.CROWD;
        }
        if (ApplicationBean.ApplicationType.JIRA.equals((Object)applicationBeanType)) {
            return ApplicationType.JIRA;
        }
        if (ApplicationBean.ApplicationType.CONFLUENCE.equals((Object)applicationBeanType)) {
            return ApplicationType.CONFLUENCE;
        }
        if (ApplicationBean.ApplicationType.BITBUCKET.equals((Object)applicationBeanType)) {
            return ApplicationType.STASH;
        }
        if (ApplicationBean.ApplicationType.FISHEYE.equals((Object)applicationBeanType)) {
            return ApplicationType.FISHEYE;
        }
        if (ApplicationBean.ApplicationType.CRUCIBLE.equals((Object)applicationBeanType)) {
            return ApplicationType.CRUCIBLE;
        }
        if (ApplicationBean.ApplicationType.BAMBOO.equals((Object)applicationBeanType)) {
            return ApplicationType.BAMBOO;
        }
        return null;
    }

    @NotNull
    public static Set<RemoteAddress> toAddressSet(@Nullable Collection<String> remoteAddresses) {
        if (remoteAddresses == null) {
            return new HashSet<RemoteAddress>();
        }
        return remoteAddresses.stream().map(RemoteAddress::new).collect(Collectors.toSet());
    }

    @NotNull
    public static Collection<String> toStringCollection(@NotNull Set<RemoteAddress> remoteAddresses) {
        return remoteAddresses.stream().map(RemoteAddress::getAddress).sorted().collect(Collectors.toList());
    }

    private ApplicationBeanUtil() {
    }
}

