/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.lookandfeel.LookAndFeelConfiguration;
import com.atlassian.crowd.util.ImageInfo;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.crowd.model.SettingsBrandingLoginPageBean;
import de.aservo.confapi.crowd.service.api.SettingsBrandingService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SettingsBrandingService.class})
public class SettingsBrandingServiceImpl
implements SettingsBrandingService {
    private final PropertyManager propertyManager;

    @Inject
    public SettingsBrandingServiceImpl(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    @Override
    public SettingsBrandingLoginPageBean getLoginPage() {
        SettingsBrandingLoginPageBean settingsBrandingLoginPageBean = new SettingsBrandingLoginPageBean();
        LookAndFeelConfiguration lookAndFeelConfiguration = this.getLookAndFeelConfiguration();
        settingsBrandingLoginPageBean.setHeader(lookAndFeelConfiguration.getHeader());
        settingsBrandingLoginPageBean.setContent(lookAndFeelConfiguration.getWelcomeText());
        settingsBrandingLoginPageBean.setButtonColor(lookAndFeelConfiguration.getPrimaryColor());
        settingsBrandingLoginPageBean.setShowLogo(lookAndFeelConfiguration.isShowLogo());
        return settingsBrandingLoginPageBean;
    }

    @Override
    public SettingsBrandingLoginPageBean setLoginPage(SettingsBrandingLoginPageBean settingsBrandingLoginPageBean) {
        LookAndFeelConfiguration lookAndFeelConfiguration = this.getLookAndFeelConfiguration();
        LookAndFeelConfiguration.Builder builder = LookAndFeelConfiguration.builder((LookAndFeelConfiguration)lookAndFeelConfiguration);
        if (settingsBrandingLoginPageBean.getShowLogo() != null) {
            builder.setShowLogo(settingsBrandingLoginPageBean.getShowLogo().booleanValue());
        }
        if (settingsBrandingLoginPageBean.getHeader() != null) {
            builder.setHeader(settingsBrandingLoginPageBean.getHeader());
        }
        if (settingsBrandingLoginPageBean.getContent() != null) {
            builder.setWelcomeText(settingsBrandingLoginPageBean.getContent());
        }
        if (settingsBrandingLoginPageBean.getButtonColor() != null) {
            builder.setPrimaryColor(settingsBrandingLoginPageBean.getButtonColor());
        }
        try {
            this.propertyManager.setLookAndFeelConfiguration(builder.build(), null);
        }
        catch (PropertyManagerException e) {
            throw new BadRequestException(e.getMessage());
        }
        return this.getLoginPage();
    }

    @Override
    public void setLogo(@NotNull InputStream inputStream) {
        ImageInfo imageInfo = this.getImageInfo(inputStream);
        LookAndFeelConfiguration.Builder builder = LookAndFeelConfiguration.builder((LookAndFeelConfiguration)this.getLookAndFeelConfiguration());
        builder.setCustomLogoId(imageInfo.getName());
        try {
            this.propertyManager.setLookAndFeelConfiguration(builder.build(), imageInfo);
        }
        catch (PropertyManagerException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private LookAndFeelConfiguration getLookAndFeelConfiguration() {
        try {
            Optional lookAndFeelConfigurationOptional = this.propertyManager.getLookAndFeelConfiguration();
            if (lookAndFeelConfigurationOptional.isPresent()) {
                return (LookAndFeelConfiguration)lookAndFeelConfigurationOptional.get();
            }
        }
        catch (PropertyManagerException e) {
            throw new InternalServerErrorException(e.getMessage());
        }
        return LookAndFeelConfiguration.builder().build();
    }

    private ImageInfo getImageInfo(InputStream inputStream) {
        ImageInfo imageInfo;
        try {
            File file = File.createTempFile("image", null);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
            String contentType = file.toURI().toURL().openConnection().getContentType();
            Set allowedTypes = Stream.of("png", "jpg").collect(Collectors.toSet());
            String extension = contentType.split("/")[1];
            if (!allowedTypes.contains(extension)) {
                throw new BadRequestException("The content type must be one of: " + allowedTypes.toString());
            }
            byte[] fileContent = Files.readAllBytes(file.toPath());
            String base64File = Base64.getEncoder().encodeToString(fileContent);
            imageInfo = new ImageInfo("name", base64File, extension);
            file.deleteOnExit();
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        return imageInfo;
    }
}

