/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.model.util;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoryGenericBean;
import de.aservo.confapi.commons.model.DirectoryInternalBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class DirectoryBeanUtil {
    public static final String LIST_SEPARATOR = ",";

    @Nullable
    public static AbstractDirectoryBean toDirectoryBean(@Nullable Directory directory) {
        if (directory == null) {
            return null;
        }
        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            return DirectoryBeanUtil.toDirectoryInternalBean(directory);
        }
        return DirectoryBeanUtil.toDirectoryGenericBean(directory);
    }

    private static DirectoryInternalBean toDirectoryInternalBean(Directory directory) {
        DirectoryInternalBean directoryBean = new DirectoryInternalBean();
        directoryBean.setId(directory.getId());
        directoryBean.setName(directory.getName());
        directoryBean.setDescription(directory.getDescription());
        directoryBean.setActive(directory.isActive());
        Map directoryAttributes = directory.getAttributes();
        directoryBean.setCredentialPolicy(new DirectoryInternalBean.DirectoryInternalCredentialPolicy());
        directoryBean.getCredentialPolicy().setPasswordRegex((String)directoryAttributes.get("password_regex"));
        directoryBean.getCredentialPolicy().setPasswordComplexityMessage((String)directoryAttributes.get("password_complexity_message"));
        directoryBean.getCredentialPolicy().setPasswordMaxAttempts(DirectoryBeanUtil.toLong((String)directoryAttributes.get("password_max_attempts")));
        directoryBean.getCredentialPolicy().setPasswordHistoryCount(DirectoryBeanUtil.toLong((String)directoryAttributes.get("password_history_count")));
        directoryBean.getCredentialPolicy().setPasswordMaxChangeTime(DirectoryBeanUtil.toLong((String)directoryAttributes.get("password_max_change_time")));
        directoryBean.getCredentialPolicy().setPasswordExpiryNotificationDays(DirectoryBeanUtil.toList((String)directoryAttributes.get("password_expiration_notification_periods")));
        directoryBean.getCredentialPolicy().setPasswordEncryptionMethod((String)directoryAttributes.get("user_encryption_method"));
        return directoryBean;
    }

    private static DirectoryGenericBean toDirectoryGenericBean(Directory directory) {
        DirectoryGenericBean directoryBean = new DirectoryGenericBean();
        directoryBean.setId(directory.getId());
        directoryBean.setName(directory.getName());
        directoryBean.setDescription(directory.getDescription());
        directoryBean.setActive(directory.isActive());
        return directoryBean;
    }

    @Nullable
    public static Directory toDirectory(@Nullable AbstractDirectoryBean directoryBean) {
        if (directoryBean == null) {
            return null;
        }
        DirectoryType directoryType = DirectoryType.UNKNOWN;
        HashMap<String, String> directoryAttributes = new HashMap<String, String>();
        if (directoryBean instanceof DirectoryInternalBean) {
            directoryType = DirectoryType.INTERNAL;
            DirectoryInternalBean directoryInternalBean = (DirectoryInternalBean)directoryBean;
            DirectoryInternalBean.DirectoryInternalCredentialPolicy credentialPolicy = directoryInternalBean.getCredentialPolicy();
            if (credentialPolicy != null) {
                directoryAttributes.put("password_regex", credentialPolicy.getPasswordRegex());
                directoryAttributes.put("password_complexity_message", credentialPolicy.getPasswordComplexityMessage());
                directoryAttributes.put("password_max_attempts", DirectoryBeanUtil.fromLong(credentialPolicy.getPasswordMaxAttempts()));
                directoryAttributes.put("password_history_count", DirectoryBeanUtil.fromLong(credentialPolicy.getPasswordHistoryCount()));
                directoryAttributes.put("password_max_change_time", DirectoryBeanUtil.fromLong(credentialPolicy.getPasswordMaxChangeTime()));
                directoryAttributes.put("password_expiration_notification_periods", DirectoryBeanUtil.fromList(credentialPolicy.getPasswordExpiryNotificationDays()));
                directoryAttributes.put("user_encryption_method", credentialPolicy.getPasswordEncryptionMethod());
            }
        }
        return ImmutableDirectory.builder((String)directoryBean.getName(), (DirectoryType)directoryType, (String)"").setId(directoryBean.getId()).setDescription(directoryBean.getDescription()).setActive(directoryBean.getActive().booleanValue()).setAttributes(directoryAttributes).build();
    }

    private static String fromList(@Nullable List<Integer> value) {
        if (value == null) {
            return null;
        }
        return value.stream().sorted().map(String::valueOf).collect(Collectors.joining(LIST_SEPARATOR));
    }

    @Nullable
    private static String fromLong(@Nullable Long value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Nullable
    private static List<Integer> toList(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(value.split(LIST_SEPARATOR)).sorted().map(Integer::valueOf).collect(Collectors.toList());
    }

    @Nullable
    private static Long toLong(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    private DirectoryBeanUtil() {
    }
}

