/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest.api;

import de.aservo.confapi.commons.model.ApplicationLinkBean;
import de.aservo.confapi.commons.model.ApplicationLinksBean;
import de.aservo.confapi.commons.model.ErrorCollection;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface ApplicationLinksResource {
    @GET
    @Produces(value={"application/json"})
    @Operation(tags={"application-links"}, summary="Get all application links", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationLinksBean.class))}, description="Returns all application links."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getApplicationLinks();

    @GET
    @Path(value="{uuid}")
    @Produces(value={"application/json"})
    @Operation(tags={"application-links"}, summary="Get an application link", description="Upon successful request, ", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationLinkBean.class))}, description="Returns the requested application link."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getApplicationLink(@PathParam(value="uuid") @NotNull UUID var1);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"application-links"}, summary="Set or update a list of application links", description="NOTE: All existing application links with the same 'rpcUrl' attribute are updated.", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationLinksBean.class))}, description="Returns all application links."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setApplicationLinks(@QueryParam(value="ignore-setup-errors") @DefaultValue(value="false") boolean var1, @NotNull ApplicationLinksBean var2);

    @PUT
    @Path(value="{uuid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"application-links"}, summary="Update an application link", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationLinkBean.class))}, description="Returns the updated application link."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setApplicationLink(@PathParam(value="uuid") @NotNull UUID var1, @QueryParam(value="ignore-setup-errors") @DefaultValue(value="false") boolean var2, @NotNull ApplicationLinkBean var3);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"application-links"}, summary="Add an application link", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationLinkBean.class))}, description="Returns the added application link."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response addApplicationLink(@QueryParam(value="ignore-setup-errors") @DefaultValue(value="false") boolean var1, @NotNull ApplicationLinkBean var2);

    @DELETE
    @Operation(tags={"application-links"}, summary="Delete all application links", description="NOTE: The 'force' parameter must be set to 'true' in order to execute this request.", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteApplicationLinks(@QueryParam(value="force") boolean var1);

    @DELETE
    @Path(value="{uuid}")
    @Operation(tags={"application-links"}, summary="Delete an application link", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteApplicationLink(@PathParam(value="uuid") @NotNull UUID var1);
}

