/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.manager.mail.MailConfiguration;
import com.atlassian.crowd.manager.mail.MailConfigurationService;
import com.atlassian.crowd.util.mail.SMTPServer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.model.MailServerPopBean;
import de.aservo.confapi.commons.model.MailServerSmtpBean;
import de.aservo.confapi.commons.service.api.MailServerService;
import de.aservo.confapi.crowd.model.util.MailServerSmtpBeanUtil;
import java.util.Collections;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={MailServerService.class})
public class MailServerServiceImpl
implements MailServerService {
    @ComponentImport
    private final MailConfigurationService mailConfigurationService;

    @Inject
    public MailServerServiceImpl(MailConfigurationService mailConfigurationService) {
        this.mailConfigurationService = mailConfigurationService;
    }

    @Override
    public MailServerSmtpBean getMailServerSmtp() {
        if (this.mailConfigurationService.isConfigured()) {
            return MailServerSmtpBeanUtil.toMailServerSmtpBean(this.mailConfigurationService.getMailConfiguration());
        }
        return null;
    }

    @Override
    public MailServerSmtpBean setMailServerSmtp(MailServerSmtpBean mailServerSmtpBean) {
        try {
            MailConfiguration mailConfiguration = this.mailConfigurationService.getMailConfiguration();
            MailConfiguration newMailConfiguration = MailConfiguration.builder((MailConfiguration)mailConfiguration).setNotificationEmails(Collections.singletonList(mailServerSmtpBean.getAdminContact())).setSmtpServer(SMTPServer.builder().setFrom(new InternetAddress(mailServerSmtpBean.getFrom())).setPrefix(mailServerSmtpBean.getPrefix()).setHost(mailServerSmtpBean.getHost()).build()).build();
            this.mailConfigurationService.saveConfiguration(newMailConfiguration);
            return this.getMailServerSmtp();
        }
        catch (AddressException e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    @Override
    public MailServerPopBean getMailServerPop() {
        throw new UnsupportedOperationException("Getting POP mail server is not implemented");
    }

    @Override
    public MailServerPopBean setMailServerPop(MailServerPopBean mailServerPopBean) {
        throw new UnsupportedOperationException("Setting POP mail server is not implemented");
    }
}

