/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoriesBean;
import de.aservo.confapi.crowd.model.util.DirectoryBeanUtil;
import de.aservo.confapi.crowd.service.api.DirectoriesService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={DirectoriesService.class})
public class DirectoriesServiceImpl
implements DirectoriesService {
    private static final Logger log = LoggerFactory.getLogger(DirectoriesServiceImpl.class);
    @ComponentImport
    private final DirectoryManager directoryManager;

    @Inject
    public DirectoriesServiceImpl(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Override
    public DirectoriesBean getDirectories() {
        EntityQuery directoryEntityQuery = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1);
        return new DirectoriesBean(this.directoryManager.searchDirectories(directoryEntityQuery).stream().filter(d -> d.getType().equals((Object)DirectoryType.INTERNAL)).map(DirectoryBeanUtil::toDirectoryBean).collect(Collectors.toList()));
    }

    @Override
    public AbstractDirectoryBean getDirectory(long id) {
        try {
            Directory directory = this.directoryManager.findDirectoryById(id);
            return DirectoryBeanUtil.toDirectoryBean(directory);
        }
        catch (DirectoryNotFoundException e) {
            log.info("Directory with id {} could not been found", (Object)id);
            return null;
        }
    }
}

