/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAlreadyExistsException;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.exception.NotFoundException;
import de.aservo.confapi.crowd.model.ApplicationBean;
import de.aservo.confapi.crowd.model.ApplicationsBean;
import de.aservo.confapi.crowd.model.util.ApplicationBeanUtil;
import de.aservo.confapi.crowd.service.api.ApplicationsService;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ApplicationsService.class})
public class ApplicationsServiceImpl
implements ApplicationsService {
    private final ApplicationManager applicationManager;

    @Inject
    public ApplicationsServiceImpl(@ComponentImport ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    @Override
    public ApplicationsBean getApplications() {
        return new ApplicationsBean(this.applicationManager.findAll().stream().map(ApplicationBeanUtil::toApplicationBean).collect(Collectors.toList()));
    }

    @Override
    public ApplicationBean getApplication(long id) {
        try {
            return ApplicationBeanUtil.toApplicationBean(this.applicationManager.findById(id));
        }
        catch (ApplicationNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public ApplicationsBean setApplications(ApplicationsBean applicationsBean) {
        ArrayList<ApplicationBean> applicationBeans = new ArrayList<ApplicationBean>();
        for (ApplicationBean applicationBean : applicationsBean.getApplications()) {
            try {
                Application application = this.applicationManager.findByName(applicationBean.getName());
                applicationBeans.add(this.setApplication(application.getId(), applicationBean));
            }
            catch (ApplicationNotFoundException ignored) {
                applicationBeans.add(this.addApplication(applicationBean));
            }
        }
        return new ApplicationsBean(applicationBeans);
    }

    @Override
    public ApplicationBean setApplication(long id, ApplicationBean applicationBean) {
        try {
            Application existingApplication = this.applicationManager.findById(id);
            ImmutableApplication.Builder applicationBuilder = new ImmutableApplication.Builder(existingApplication);
            if (applicationBean.getName() != null) {
                applicationBuilder.setName(applicationBean.getName());
            }
            if (applicationBean.getType() != null) {
                applicationBuilder.setType(ApplicationBeanUtil.toApplicationType(applicationBean.getType()));
            }
            if (applicationBean.getDescription() != null) {
                applicationBuilder.setDescription(applicationBean.getDescription());
            }
            if (applicationBean.getActive() != null) {
                applicationBuilder.setActive(applicationBean.getActive().booleanValue());
            }
            if (applicationBean.getPassword() != null) {
                this.applicationManager.updateCredential(existingApplication, PasswordCredential.unencrypted((String)applicationBean.getPassword()));
            }
            return ApplicationBeanUtil.toApplicationBean(this.applicationManager.update((Application)applicationBuilder.build()));
        }
        catch (ApplicationNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (ApplicationManagerException e) {
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public ApplicationBean addApplication(ApplicationBean applicationBean) {
        try {
            Application createdApplication = this.applicationManager.add(ApplicationBeanUtil.toApplication(applicationBean));
            return ApplicationBeanUtil.toApplicationBean(createdApplication);
        }
        catch (ApplicationAlreadyExistsException | InvalidCredentialException e) {
            throw new BadRequestException(e);
        }
    }

    @Override
    public void deleteApplications(boolean force) {
        if (!force) {
            throw new BadRequestException("Set 'force' query param to true in order to delete all applications");
        }
        this.applicationManager.findAll().forEach(a -> this.deleteApplication(a.getId()));
    }

    @Override
    public void deleteApplication(long id) {
        try {
            Application application = this.applicationManager.findById(id);
            this.applicationManager.remove(application);
        }
        catch (ApplicationNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (ApplicationManagerException e) {
            throw new InternalServerErrorException(e);
        }
    }
}

