/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.rest;

import com.sun.jersey.spi.container.ResourceFilters;
import de.aservo.confapi.commons.exception.NotFoundException;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.crowd.filter.SysadminOnlyResourceFilter;
import de.aservo.confapi.crowd.rest.api.DirectoriesResource;
import de.aservo.confapi.crowd.service.api.DirectoriesService;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="directories")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@Component
public class DirectoriesResourceImpl
implements DirectoriesResource {
    private final DirectoriesService directoriesService;

    @Inject
    public DirectoriesResourceImpl(DirectoriesService directoriesService) {
        this.directoriesService = directoriesService;
    }

    @Override
    public Response getDirectories() {
        return Response.ok((Object)this.directoriesService.getDirectories()).build();
    }

    @Override
    public Response getDirectory(long id) {
        AbstractDirectoryBean directoryBean = this.directoriesService.getDirectory(id);
        if (directoryBean == null) {
            throw new NotFoundException(String.format("Directory with ID '%d' cannot be found", id));
        }
        return Response.ok((Object)directoryBean).build();
    }
}

