/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.UserBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractUserResourceFuncTest {
    private static final String PARAM_USERNAME = "username";

    @Test
    void testGetUser() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).build();
        ClientResponse clientResponse = usersResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        UserBean userBean = (UserBean)clientResponse.getEntity(UserBean.class);
        Assertions.assertNotNull((Object)userBean);
    }

    @Test
    void testSetUserEmailAddress() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).build();
        ClientResponse clientResponse = usersResource.put((Object)exampleBean);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        UserBean userBean = (UserBean)clientResponse.getEntity(UserBean.class);
        Assertions.assertEquals((Object)exampleBean.getEmail(), (Object)userBean.getEmail());
    }

    @Test
    void testSetUserPassword() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users/password" + this.getUserNameQueryParam(exampleBean)).contentMediaType("text/plain").build();
        ClientResponse clientResponse = usersResource.put((Object)exampleBean.getPassword());
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
    }

    @Test
    public void testGetUserUnauthenticated() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> ((Resource)usersResource).get());
    }

    @Test
    public void testSetUserEmailAddressUnauthenticated() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> usersResource.put((Object)exampleBean));
    }

    @Test
    void testGetUserUnauthorized() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("user").password("user").build();
        usersResource.get();
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)usersResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    @Test
    void testSetUserEmailAddressUnauthorized() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("user").password("user").build();
        usersResource.put((Object)exampleBean);
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)usersResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    protected String getUserNameQueryParam(UserBean userBean) {
        return "?username=" + userBean.getUsername();
    }

    protected UserBean getExampleBean() {
        return UserBean.EXAMPLE_3_ADMIN;
    }
}

