/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.SettingsBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSettingsResourceFuncTest {
    @Test
    void testGetSettings() {
        Resource settingsResource = ResourceBuilder.builder("settings").build();
        ClientResponse clientResponse = settingsResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        Assertions.assertNotNull((Object)((SettingsBean)clientResponse.getEntity(SettingsBean.class)).getTitle());
    }

    @Test
    void testSetSettings() {
        Resource settingsResource = ResourceBuilder.builder("settings").build();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)settingsResource.put((Object)this.getExampleBean()).getStatusCode());
        ClientResponse clientResponse = settingsResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        Assertions.assertEquals((Object)this.getExampleBean(), (Object)clientResponse.getEntity(SettingsBean.class));
    }

    @Test
    public void testGetSettingsUnauthenticated() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> ((Resource)settingsResource).get());
    }

    @Test
    public void testSetSettingsUnauthenticated() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> settingsResource.put((Object)this.getExampleBean()));
    }

    @Test
    void testGetSettingsUnauthorized() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("user").password("user").build();
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)settingsResource.get().getStatusCode());
    }

    @Test
    void testSetSettingsUnauthorized() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("user").password("user").build();
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)settingsResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    protected SettingsBean getExampleBean() {
        return SettingsBean.EXAMPLE_1;
    }
}

