/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.MailServerSmtpBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMailServerSmtpResourceFuncTest {
    @Test
    void testGetMailServerImap() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").build();
        ClientResponse clientResponse = mailserverResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        MailServerSmtpBean mailServerSmtpBean = (MailServerSmtpBean)clientResponse.getEntity(MailServerSmtpBean.class);
        Assertions.assertNotNull((Object)mailServerSmtpBean);
    }

    @Test
    void testSetMailServerImap() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").build();
        ClientResponse clientResponse = mailserverResource.put((Object)this.getExampleBean());
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        MailServerSmtpBean mailServerSmtpBean = (MailServerSmtpBean)clientResponse.getEntity(MailServerSmtpBean.class);
        this.assertMailServerBeanAgainstExample(mailServerSmtpBean);
    }

    @Test
    public void testGetMailServerImapUnauthenticated() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> ((Resource)mailserverResource).get());
    }

    @Test
    public void testSetMailServerImapUnauthenticated() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> mailserverResource.put((Object)this.getExampleBean()));
    }

    @Test
    void testGetMailServerImapUnauthorized() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("user").password("user").build();
        ClientResponse response = mailserverResource.get();
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatusCode());
    }

    @Test
    void testSetMailServerImapUnauthorized() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("user").password("user").build();
        ClientResponse response = mailserverResource.put((Object)this.getExampleBean());
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatusCode());
    }

    protected void assertMailServerBeanAgainstExample(MailServerSmtpBean bean) {
        MailServerSmtpBean exampleBean = this.getExampleBean();
        exampleBean.setPassword(null);
        Assertions.assertEquals((Object)exampleBean, (Object)bean);
    }

    protected MailServerSmtpBean getExampleBean() {
        return MailServerSmtpBean.EXAMPLE_2;
    }
}

