/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.MailServerPopBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMailServerPopResourceFuncTest {
    @Test
    void testGetMailServerPop() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/pop").build();
        ClientResponse clientResponse = mailserverResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        MailServerPopBean mailServerPopBean = (MailServerPopBean)clientResponse.getEntity(MailServerPopBean.class);
        Assertions.assertNotNull((Object)mailServerPopBean);
    }

    @Test
    void testSetMailServerPop() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/pop").build();
        ClientResponse clientResponse = mailserverResource.put((Object)this.getExampleBean());
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        MailServerPopBean mailServerPopBean = (MailServerPopBean)clientResponse.getEntity(MailServerPopBean.class);
        this.assertMailServerBeanAgainstExample(mailServerPopBean);
    }

    @Test
    public void testGetMailServerPopUnauthenticated() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/pop").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> ((Resource)mailserverResource).get());
    }

    @Test
    public void testSetMailServerPopUnauthenticated() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/pop").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> mailserverResource.put((Object)this.getExampleBean()));
    }

    @Test
    void testGetMailServerPopUnauthorized() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/pop").username("user").password("user").build();
        ClientResponse response = mailserverResource.put((Object)this.getExampleBean());
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatusCode());
    }

    @Test
    void testSetMailServerPopUnauthorized() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/pop").username("user").password("user").build();
        ClientResponse response = mailserverResource.put((Object)this.getExampleBean());
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatusCode());
    }

    protected void assertMailServerBeanAgainstExample(MailServerPopBean bean) {
        MailServerPopBean exampleBean = this.getExampleBean();
        exampleBean.setPassword(null);
        Assertions.assertEquals((Object)exampleBean, (Object)bean);
    }

    protected MailServerPopBean getExampleBean() {
        return MailServerPopBean.EXAMPLE_2;
    }
}

