/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.LicenseBean;
import de.aservo.confapi.commons.model.LicensesBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractLicenseResourceFuncTest {
    @Test
    void testGetLicenses() {
        Resource licensesResource = ResourceBuilder.builder("licenses").build();
        ClientResponse clientResponse = licensesResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)clientResponse.getStatusCode());
        Collection licenses = ((LicensesBean)clientResponse.getEntity(LicensesBean.class)).getLicenses();
        Assertions.assertNotNull((Object)licenses);
        Assertions.assertNotEquals((int)0, (int)licenses.size());
        Assertions.assertNotNull((Object)((LicenseBean)licenses.iterator().next()).getOrganization());
    }

    @Test
    void testSetLicenses() {
        Resource licensesResource = ResourceBuilder.builder("licenses").build();
        ClientResponse response = licensesResource.put((Object)this.getExampleBean());
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusCode());
        response = licensesResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusCode());
        Assertions.assertEquals((Object)((LicenseBean)this.getExampleBean().getLicenses().iterator().next()).getDescription(), (Object)((LicenseBean)((LicensesBean)response.getEntity(LicensesBean.class)).getLicenses().iterator().next()).getDescription());
    }

    @Test
    void testAddLicenses() {
        Resource licensesResource = ResourceBuilder.builder("licenses").build();
        LicenseBean licenseBean = (LicenseBean)this.getExampleBean().getLicenses().iterator().next();
        ClientResponse response = licensesResource.post((Object)licenseBean);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusCode());
        response = licensesResource.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusCode());
        Assertions.assertEquals((Object)licenseBean.getDescription(), (Object)((LicenseBean)((LicensesBean)response.getEntity(LicensesBean.class)).getLicenses().iterator().next()).getDescription());
    }

    @Test
    public void testGetLicensesUnauthenticated() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> ((Resource)licensesResource).get());
    }

    @Test
    public void testSetLicensesUnauthenticated() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("wrong").password("password").build();
        Assertions.assertThrows(ClientAuthenticationException.class, () -> licensesResource.put((Object)this.getExampleBean()));
    }

    @Test
    void testGetLicensesUnauthorized() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("user").password("user").build();
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)licensesResource.get().getStatusCode());
    }

    @Test
    void testSetLicensesUnauthorized() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("user").password("user").build();
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)licensesResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    protected LicensesBean getExampleBean() {
        return LicensesBean.EXAMPLE_2_DEVELOPER_LICENSE;
    }
}

