/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.util;

import de.aservo.confapi.commons.util.ConversionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConversionUtilTest {
    ConversionUtilTest() {
    }

    @Test
    void testConvertLong() {
        Assertions.assertEquals((long)0L, (long)ConversionUtil.toLong(null));
        Assertions.assertEquals((long)0L, (long)ConversionUtil.toLong((String)""));
        Assertions.assertEquals((long)100L, (long)ConversionUtil.toLong((String)"100"));
        Assertions.assertEquals((long)234234234234234L, (long)ConversionUtil.toLong((String)"234234234234234"));
    }

    @Test
    void testConvertInt() {
        Assertions.assertEquals((int)0, (int)ConversionUtil.toInt(null));
        Assertions.assertEquals((int)0, (int)ConversionUtil.toInt((String)""));
        Assertions.assertEquals((int)100, (int)ConversionUtil.toInt((String)"100"));
    }

    @Test
    void testConvertDouble() {
        Assertions.assertEquals((double)0.0, (double)ConversionUtil.toDouble(null), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)ConversionUtil.toDouble((String)""), (double)0.0);
        Assertions.assertEquals((double)100.0, (double)ConversionUtil.toDouble((String)"100"), (double)0.0);
        Assertions.assertEquals((double)100.1231234, (double)ConversionUtil.toDouble((String)"100.1231234"), (double)0.0);
    }

    @Test
    void testConvertBoolean() {
        Assertions.assertFalse((boolean)ConversionUtil.toBoolean(null));
        Assertions.assertFalse((boolean)ConversionUtil.toBoolean((String)""));
        Assertions.assertFalse((boolean)ConversionUtil.toBoolean((String)"false"));
        Assertions.assertFalse((boolean)ConversionUtil.toBoolean((String)"False"));
        Assertions.assertFalse((boolean)ConversionUtil.toBoolean((String)"no"));
        Assertions.assertFalse((boolean)ConversionUtil.toBoolean((String)"0"));
        Assertions.assertTrue((boolean)ConversionUtil.toBoolean((String)"1"));
        Assertions.assertTrue((boolean)ConversionUtil.toBoolean((String)"true"));
        Assertions.assertTrue((boolean)ConversionUtil.toBoolean((String)"TRUE"));
        Assertions.assertTrue((boolean)ConversionUtil.toBoolean((String)"yes"));
        Assertions.assertTrue((boolean)ConversionUtil.toBoolean((String)"ja"));
    }
}

