/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.SettingsBrandingColorSchemeBean;
import de.aservo.confapi.commons.rest.impl.TestSettingsBrandingResourceImpl;
import de.aservo.confapi.commons.service.api.SettingsBrandingService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class SettingsBrandingResourceTest {
    @Mock
    private SettingsBrandingService brandingService;
    private TestSettingsBrandingResourceImpl resource;

    SettingsBrandingResourceTest() {
    }

    @BeforeEach
    public void setup() {
        this.resource = new TestSettingsBrandingResourceImpl(this.brandingService);
    }

    @Test
    void testGetColourScheme() {
        SettingsBrandingColorSchemeBean bean = SettingsBrandingColorSchemeBean.EXAMPLE_1;
        ((SettingsBrandingService)Mockito.doReturn((Object)bean).when((Object)this.brandingService)).getColourScheme();
        Response response = this.resource.getBrandingColorScheme();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        SettingsBrandingColorSchemeBean colourSchemeBean = (SettingsBrandingColorSchemeBean)response.getEntity();
        Assertions.assertEquals((Object)colourSchemeBean, (Object)bean);
    }

    @Test
    void testSetColourScheme() {
        SettingsBrandingColorSchemeBean bean = SettingsBrandingColorSchemeBean.EXAMPLE_1;
        ((SettingsBrandingService)Mockito.doReturn((Object)bean).when((Object)this.brandingService)).setColourScheme(bean);
        Response response = this.resource.setBrandingColorScheme(bean);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        SettingsBrandingColorSchemeBean colourSchemeBean = (SettingsBrandingColorSchemeBean)response.getEntity();
        Assertions.assertEquals((Object)colourSchemeBean, (Object)bean);
    }

    @Test
    void testGetLogo() {
        InputStream stream = this.createDummyInputStream();
        ((SettingsBrandingService)Mockito.doReturn((Object)stream).when((Object)this.brandingService)).getLogo();
        Response response = this.resource.getBrandingLogo();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStream inputStream = (InputStream)response.getEntity();
        Assertions.assertNotNull((Object)inputStream);
    }

    @Test
    void testSetLogo() {
        InputStream stream = this.createDummyInputStream();
        Response response = this.resource.setBrandingLogo(stream);
        Assertions.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    void testGetFavicon() {
        InputStream stream = this.createDummyInputStream();
        ((SettingsBrandingService)Mockito.doReturn((Object)stream).when((Object)this.brandingService)).getFavicon();
        Response response = this.resource.getBrandingFavicon();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStream inputStream = (InputStream)response.getEntity();
        Assertions.assertNotNull((Object)inputStream);
    }

    @Test
    void testSetFavicon() {
        InputStream stream = this.createDummyInputStream();
        Response response = this.resource.setBrandingFavicon(stream);
        Assertions.assertEquals((int)200, (int)response.getStatus());
    }

    private InputStream createDummyInputStream() {
        return new ByteArrayInputStream("TEST-STREAM".getBytes());
    }
}

