/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoriesBean;
import de.aservo.confapi.commons.model.DirectoryCrowdBean;
import de.aservo.confapi.commons.rest.impl.TestDirectoriesResourceImpl;
import de.aservo.confapi.commons.service.api.DirectoriesService;
import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DirectoriesResourceTest {
    @Mock
    private DirectoriesService directoriesService;
    private TestDirectoriesResourceImpl resource;

    DirectoriesResourceTest() {
    }

    @BeforeEach
    public void setup() {
        this.resource = new TestDirectoriesResourceImpl(this.directoriesService);
    }

    @Test
    void testGetDirectories() {
        DirectoryCrowdBean initialDirectoryBean = DirectoryCrowdBean.EXAMPLE_1;
        DirectoriesBean directoriesBean = new DirectoriesBean(Collections.singleton(initialDirectoryBean));
        ((DirectoriesService)Mockito.doReturn((Object)directoriesBean).when((Object)this.directoriesService)).getDirectories();
        Response response = this.resource.getDirectories();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        DirectoriesBean directoriesBeanResponse = (DirectoriesBean)response.getEntity();
        Assertions.assertEquals((Object)initialDirectoryBean, directoriesBeanResponse.getDirectories().iterator().next());
    }

    @Test
    void testGetDirectory() {
        DirectoryCrowdBean directoryBean = DirectoryCrowdBean.EXAMPLE_1;
        ((DirectoriesService)Mockito.doReturn((Object)directoryBean).when((Object)this.directoriesService)).getDirectory(1L);
        Response response = this.resource.getDirectory(1L);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        AbstractDirectoryBean directoryBeanResponse = (AbstractDirectoryBean)response.getEntity();
        Assertions.assertEquals((Object)directoryBean, (Object)directoryBeanResponse);
    }

    @Test
    void testSetDirectories() {
        DirectoryCrowdBean directoryBean1 = DirectoryCrowdBean.EXAMPLE_1;
        DirectoryCrowdBean directoryBean2 = DirectoryCrowdBean.EXAMPLE_3;
        DirectoriesBean directoriesBean = new DirectoriesBean(Arrays.asList(directoryBean1, directoryBean2));
        ((DirectoriesService)Mockito.doReturn((Object)directoriesBean).when((Object)this.directoriesService)).setDirectories(directoriesBean, false);
        Response response = this.resource.setDirectories(Boolean.FALSE, directoriesBean);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        DirectoriesBean directoriesBeanResponse = (DirectoriesBean)response.getEntity();
        Assertions.assertEquals((int)directoriesBean.getDirectories().size(), (int)directoriesBeanResponse.getDirectories().size());
    }

    @Test
    void testSetDirectory() {
        DirectoryCrowdBean directoryBean = DirectoryCrowdBean.EXAMPLE_1;
        ((DirectoriesService)Mockito.doReturn((Object)directoryBean).when((Object)this.directoriesService)).setDirectory(1L, (AbstractDirectoryBean)directoryBean, false);
        Response response = this.resource.setDirectory(1L, Boolean.FALSE, (AbstractDirectoryBean)directoryBean);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        AbstractDirectoryBean directoryBeanResponse = (AbstractDirectoryBean)response.getEntity();
        Assertions.assertEquals((Object)directoryBean, (Object)directoryBeanResponse);
    }

    @Test
    void testAddDirectory() {
        DirectoryCrowdBean bean = DirectoryCrowdBean.EXAMPLE_1;
        ((DirectoriesService)Mockito.doReturn((Object)bean).when((Object)this.directoriesService)).addDirectory((AbstractDirectoryBean)bean, false);
        Response response = this.resource.addDirectory(Boolean.FALSE, (AbstractDirectoryBean)bean);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        AbstractDirectoryBean responseBean = (AbstractDirectoryBean)response.getEntity();
        Assertions.assertEquals((Object)bean.getName(), (Object)responseBean.getName());
    }

    @Test
    void testDeleteDirectories() {
        this.resource.deleteDirectories(true);
        Assertions.assertTrue((boolean)true, (String)"Delete Successful");
    }

    @Test
    void testDeleteDirectory() {
        this.resource.deleteDirectory(1L);
        Assertions.assertTrue((boolean)true, (String)"Delete Successful");
    }
}

