/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.model;

import de.aservo.confapi.commons.model.ErrorCollection;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ErrorCollectionTest {
    public static final String FIRST_ERROR_MESSAGE = "First error message";
    public static final String SECOND_ERROR_MESSAGE = "Second error message";
    private ErrorCollection errorCollection;

    ErrorCollectionTest() {
    }

    @BeforeEach
    public void setup() {
        this.errorCollection = new ErrorCollection();
    }

    @Test
    void testDefaultConstructor() {
        Assertions.assertFalse((boolean)this.errorCollection.hasAnyErrors());
    }

    @Test
    void testAddErrorMessage() {
        this.errorCollection.addErrorMessage(FIRST_ERROR_MESSAGE);
        Assertions.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assertions.assertEquals((int)1, (int)this.errorCollection.getErrorMessages().size());
        Assertions.assertTrue((boolean)this.errorCollection.getErrorMessages().contains(FIRST_ERROR_MESSAGE));
    }

    @Test
    void testAddNullErrorMessage() {
        this.errorCollection.addErrorMessage(null);
        Assertions.assertFalse((boolean)this.errorCollection.hasAnyErrors());
    }

    @Test
    void testAddErrorMessageList() {
        this.errorCollection.addErrorMessages(Arrays.asList(FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE));
        Assertions.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assertions.assertEquals((int)2, (int)this.errorCollection.getErrorMessages().size());
        Assertions.assertTrue((boolean)this.errorCollection.getErrorMessages().containsAll(Arrays.asList(FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE)));
    }

    @Test
    void testAddNullErrorMessageList() {
        this.errorCollection.addErrorMessages(null);
        Assertions.assertFalse((boolean)this.errorCollection.hasAnyErrors());
    }

    @Test
    void testOfErrorMessages() {
        this.errorCollection = ErrorCollection.of((String[])new String[]{FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE});
        Assertions.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assertions.assertEquals((int)2, (int)this.errorCollection.getErrorMessages().size());
        Assertions.assertTrue((boolean)this.errorCollection.getErrorMessages().containsAll(Arrays.asList(FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE)));
    }

    @Test
    void testOfErrorMessageList() {
        this.errorCollection = ErrorCollection.of(Arrays.asList(FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE));
        Assertions.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assertions.assertEquals((int)2, (int)this.errorCollection.getErrorMessages().size());
        Assertions.assertTrue((boolean)this.errorCollection.getErrorMessages().containsAll(Arrays.asList(FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE)));
    }
}

