/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.junit;

import de.aservo.confapi.commons.junit.AbstractTest;
import javax.ws.rs.WebApplicationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractExceptionTest
extends AbstractTest {
    private static final String CLASS_SUFFIX = "Exception";
    private static final String MESSAGE = "Exception";

    @Test
    void exceptionClassNameShouldEndWithSuffixException() {
        String beanClassName = this.getBaseClass().getSimpleName();
        Assertions.assertTrue((boolean)beanClassName.endsWith("Exception"), (String)"The model class name should end with suffix Exception");
    }

    @Test
    void exceptionClassShouldExtendWebApplicationException() {
        Assertions.assertTrue((boolean)WebApplicationException.class.isAssignableFrom(this.getBaseClass()), (String)"The exception class should extend WebApplicationException");
    }

    @Test
    void exceptionConstructorsShouldBehaveEqually() throws Exception {
        Class<?> baseClass = this.getBaseClass();
        WebApplicationException messageException = (WebApplicationException)baseClass.getConstructor(String.class).newInstance("Exception");
        WebApplicationException throwableException = (WebApplicationException)baseClass.getConstructor(Throwable.class).newInstance(new Exception("Exception"));
        Assertions.assertEquals((Object)throwableException.getMessage(), (Object)messageException.getMessage(), (String)"The message for both constructors should be equal");
        Assertions.assertEquals((int)throwableException.getResponse().getStatus(), (int)messageException.getResponse().getStatus(), (String)"The status code for both constructors should be equal");
    }
}

