/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.junit;

import com.google.common.base.CaseFormat;
import de.aservo.confapi.commons.junit.AbstractTest;
import javax.xml.bind.annotation.XmlRootElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractBeanTest
extends AbstractTest {
    private static final String CLASS_SUFFIX = "Bean";

    @Test
    void beanClassNameShouldEndWithSuffixBean() {
        String beanClassName = this.getBaseClass().getSimpleName();
        Assertions.assertTrue((boolean)beanClassName.endsWith(CLASS_SUFFIX), (String)"The model class name should end with suffix Bean");
    }

    @Test
    void beanClassNameAndXmlRootElementShouldMatch() {
        String beanClassName = this.getBaseClass().getSimpleName();
        String beanClassBaseName = beanClassName.substring(0, beanClassName.length() - CLASS_SUFFIX.length());
        XmlRootElement xmlRootElement = this.getBaseClass().getAnnotation(XmlRootElement.class);
        Assertions.assertNotNull((Object)xmlRootElement);
        Assertions.assertEquals((Object)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, beanClassBaseName), (Object)xmlRootElement.name(), (String)"The model class camel-case base name and the xml root element kebab-case base name should match");
    }
}

