/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.exception.mapper;

import de.aservo.confapi.commons.exception.NotFoundException;
import de.aservo.confapi.commons.exception.mapper.WebApplicationExceptionMapper;
import de.aservo.confapi.commons.model.ErrorCollection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WebApplicationExceptionMapperTest {
    private static final String MESSAGE = "Space with key 'KEY' does not exist";

    WebApplicationExceptionMapperTest() {
    }

    @Test
    void testResponse() {
        WebApplicationExceptionMapper webApplicationExceptionMapper = new WebApplicationExceptionMapper();
        NotFoundException notFoundException = new NotFoundException(MESSAGE);
        Response response = webApplicationExceptionMapper.toResponse((WebApplicationException)notFoundException);
        ErrorCollection errorCollection = (ErrorCollection)response.getEntity();
        String errorMessage = (String)errorCollection.getErrorMessages().iterator().next();
        Assertions.assertEquals((int)notFoundException.getResponse().getStatus(), (int)response.getStatus(), (String)"Web application exceptions should be mapped to their own response status");
        Assertions.assertEquals((int)1, (int)errorCollection.getErrorMessages().size(), (String)"The response error collection size is wrong");
        Assertions.assertEquals((Object)MESSAGE, (Object)errorMessage);
    }
}

