/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.UserBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractUserResourceFuncTest {
    private static final String PARAM_USERNAME = "username";

    @Test
    public void testGetUser() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).build();
        ClientResponse clientResponse = usersResource.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
        UserBean userBean = (UserBean)clientResponse.getEntity(UserBean.class);
        Assert.assertNotNull((Object)userBean);
    }

    @Test
    public void testSetUserEmailAddress() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).build();
        ClientResponse clientResponse = usersResource.put((Object)exampleBean);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
        UserBean userBean = (UserBean)clientResponse.getEntity(UserBean.class);
        Assert.assertEquals((Object)exampleBean, (Object)userBean);
    }

    @Test
    public void testSetUserPassword() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users/password" + this.getUserNameQueryParam(exampleBean)).contentMediaType("text/plain").build();
        ClientResponse clientResponse = usersResource.put((Object)exampleBean.getPassword());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testGetUserUnauthenticated() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("wrong").password("password").build();
        usersResource.get();
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testSetUserEmailAddressUnauthenticated() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("wrong").password("password").build();
        usersResource.put((Object)exampleBean);
    }

    @Test
    public void testGetUserUnauthorized() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("user").password("user").build();
        usersResource.get();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)usersResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    @Test
    public void testSetUserEmailAddressUnauthorized() {
        UserBean exampleBean = this.getExampleBean();
        Resource usersResource = ResourceBuilder.builder("users" + this.getUserNameQueryParam(exampleBean)).username("user").password("user").build();
        usersResource.put((Object)exampleBean);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)usersResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    protected String getUserNameQueryParam(UserBean userBean) {
        return "?username=" + userBean.getUsername();
    }

    protected UserBean getExampleBean() {
        return UserBean.EXAMPLE_3_ADMIN;
    }
}

