/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.LicenseBean;
import de.aservo.confapi.commons.model.LicensesBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLicenseResourceFuncTest {
    @Test
    public void testGetLicenses() {
        Resource licensesResource = ResourceBuilder.builder("licenses").build();
        ClientResponse clientResponse = licensesResource.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
        Collection licenses = ((LicensesBean)clientResponse.getEntity(LicensesBean.class)).getLicenses();
        Assert.assertNotNull((Object)licenses);
        Assert.assertNotEquals((long)0L, (long)licenses.size());
        Assert.assertNotNull((Object)((LicenseBean)licenses.iterator().next()).getOrganization());
    }

    @Test
    public void testSetLicenses() {
        Resource licensesResource = ResourceBuilder.builder("licenses").build();
        ClientResponse response = licensesResource.put((Object)this.getExampleBean());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        response = licensesResource.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        Assert.assertEquals((Object)((LicenseBean)this.getExampleBean().getLicenses().iterator().next()).getDescription(), (Object)((LicenseBean)((LicensesBean)response.getEntity(LicensesBean.class)).getLicenses().iterator().next()).getDescription());
    }

    @Test
    public void testAddLicenses() {
        Resource licensesResource = ResourceBuilder.builder("licenses").build();
        LicenseBean licenseBean = (LicenseBean)this.getExampleBean().getLicenses().iterator().next();
        ClientResponse response = licensesResource.post((Object)licenseBean);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        response = licensesResource.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        Assert.assertEquals((Object)licenseBean.getDescription(), (Object)((LicenseBean)((LicensesBean)response.getEntity(LicensesBean.class)).getLicenses().iterator().next()).getDescription());
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testGetLicensesUnauthenticated() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("wrong").password("password").build();
        licensesResource.get();
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testSetLicensesUnauthenticated() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("wrong").password("password").build();
        licensesResource.put((Object)this.getExampleBean());
    }

    @Test
    public void testGetLicensesUnauthorized() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("user").password("user").build();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)licensesResource.get().getStatusCode());
    }

    @Test
    public void testSetLicensesUnauthorized() {
        Resource licensesResource = ResourceBuilder.builder("licenses").username("user").password("user").build();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)licensesResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    protected LicensesBean getExampleBean() {
        return LicensesBean.EXAMPLE_2_DEVELOPER_LICENSE;
    }
}

