/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.junit;

import java.lang.reflect.Method;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.junit.Assert;

public class ResourceAssert {
    public static void assertResourcePath(Object resource, String path) {
        Class<?> resourceClass = resource.getClass();
        Path resourceClassAnnotation = resourceClass.getAnnotation(Path.class);
        Assert.assertNotNull((Object)resourceClassAnnotation);
        Assert.assertEquals((Object)path, (Object)resourceClassAnnotation.value());
    }

    public static void assertResourceMethodGet(Object resource, String subPath, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, subPath, "GET", methodName, parameterTypes);
    }

    public static void assertResourceMethodGetNoSubPath(Object resource, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, null, "GET", methodName, parameterTypes);
    }

    public static void assertResourceMethodPost(Object resource, String subPath, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, subPath, "POST", methodName, parameterTypes);
    }

    public static void assertResourceMethodPostNoSubPath(Object resource, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, null, "POST", methodName, parameterTypes);
    }

    public static void assertResourceMethodPut(Object resource, String subPath, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, subPath, "PUT", methodName, parameterTypes);
    }

    public static void assertResourceMethodPutNoSubPath(Object resource, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, null, "PUT", methodName, parameterTypes);
    }

    public static void assertResourceMethodDelete(Object resource, String subPath, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, subPath, "DELETE", methodName, parameterTypes);
    }

    public static void assertResourceMethodDeleteNoSubPath(Object resource, String methodName, Class<?> ... parameterTypes) {
        ResourceAssert.assertResourceMethodInternal(resource, null, "DELETE", methodName, parameterTypes);
    }

    private static void assertResourceMethodInternal(Object resource, String subPath, String httpMethod, String methodName, Class<?> ... parameterTypes) {
        Method method;
        Class<?> resourceClass = resource.getClass();
        Path resourceClassAnnotation = resourceClass.getAnnotation(Path.class);
        Assert.assertNotNull((Object)resourceClassAnnotation);
        try {
            method = resourceClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)String.format("Method %s is not defined", methodName));
            return;
        }
        ResourceAssert.assertResourceMethodHttpMethodInternal(method, httpMethod);
        Path methodPath = method.getAnnotation(Path.class);
        if (subPath != null) {
            Assert.assertNotNull((Object)methodPath.value());
            Assert.assertEquals((Object)subPath, (Object)methodPath.value());
        } else {
            Assert.assertNull((Object)methodPath);
        }
    }

    private static void assertResourceMethodHttpMethodInternal(Method method, String httpMethod) {
        switch (httpMethod) {
            case "GET": {
                Assert.assertNotNull((Object)method.getAnnotation(GET.class));
                break;
            }
            case "POST": {
                Assert.assertNotNull((Object)method.getAnnotation(POST.class));
                break;
            }
            case "PUT": {
                Assert.assertNotNull((Object)method.getAnnotation(PUT.class));
                break;
            }
            case "DELETE": {
                Assert.assertNotNull((Object)method.getAnnotation(DELETE.class));
                break;
            }
            case "HEAD": {
                Assert.assertNotNull((Object)method.getAnnotation(HEAD.class));
                break;
            }
            case "OPTIONS": {
                Assert.assertNotNull((Object)method.getAnnotation(OPTIONS.class));
                break;
            }
            default: {
                Assert.fail((String)String.format("HTTP method %s not known", httpMethod));
            }
        }
    }
}

