/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.junit;

import de.aservo.confapi.commons.util.StringUtil;
import org.junit.Assert;

public abstract class AbstractTest {
    private static final String TEST_CLASS_SUFFIX = "Test";
    private Class<?> baseClass = null;

    public Class<?> getBaseClass() {
        if (this.baseClass == null) {
            this.baseClass = this.findBaseClass();
        }
        return this.baseClass;
    }

    private Class<?> findBaseClass() {
        Class<?> baseClass;
        String testClassName = this.getClass().getCanonicalName();
        Assert.assertTrue((String)"The test class should end with suffix Test", (boolean)testClassName.endsWith(TEST_CLASS_SUFFIX));
        String baseClassName = StringUtil.baseName(testClassName, TEST_CLASS_SUFFIX);
        try {
            baseClass = Class.forName(baseClassName);
        }
        catch (ClassNotFoundException ignored) {
            throw new AssertionError((Object)("The base class of this test should be named " + baseClassName));
        }
        return baseClass;
    }
}

