/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.junit;

import de.aservo.confapi.commons.junit.AbstractTest;
import javax.ws.rs.WebApplicationException;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractExceptionTest
extends AbstractTest {
    private static final String CLASS_SUFFIX = "Exception";
    private static final String MESSAGE = "Exception";

    @Test
    public void exceptionClassNameShouldEndWithSuffixException() {
        String beanClassName = this.getBaseClass().getSimpleName();
        Assert.assertTrue((String)"The model class name should end with suffix Exception", (boolean)beanClassName.endsWith("Exception"));
    }

    @Test
    public void exceptionClassShouldExtendWebApplicationException() {
        Assert.assertTrue((String)"The exception class should extend WebApplicationException", (boolean)WebApplicationException.class.isAssignableFrom(this.getBaseClass()));
    }

    @Test
    public void exceptionConstructorsShouldBehaveEqually() throws Exception {
        Class<?> baseClass = this.getBaseClass();
        WebApplicationException messageException = (WebApplicationException)baseClass.getConstructor(String.class).newInstance("Exception");
        WebApplicationException throwableException = (WebApplicationException)baseClass.getConstructor(Throwable.class).newInstance(new Exception("Exception"));
        Assert.assertEquals((String)"The message for both constructors should be equal", (Object)throwableException.getMessage(), (Object)messageException.getMessage());
        Assert.assertEquals((String)"The status code for both constructors should be equal", (long)throwableException.getResponse().getStatus(), (long)messageException.getResponse().getStatus());
    }
}

