/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import it.de.aservo.confapi.commons.rest.ClientApplication;
import java.util.Collections;
import javax.ws.rs.core.Application;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.BasicAuthSecurityHandler;
import org.apache.wink.client.handlers.ClientHandler;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public class ResourceBuilder {
    private static final String REST_PATH = "/rest/confapi/1/";
    private final String baseUrl = System.getProperty("baseurl");
    private String username = "admin";
    private String password = "admin";
    private String acceptMediaType = "application/json";
    private String contentMediaType = "application/json";
    private final String resourceName;

    private ResourceBuilder(String resourceName) {
        this.resourceName = resourceName;
    }

    public static ResourceBuilder builder(String resourceName) {
        return new ResourceBuilder(resourceName);
    }

    public ResourceBuilder username(String username) {
        this.username = username;
        return this;
    }

    public ResourceBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ResourceBuilder acceptMediaType(String acceptMediaType) {
        this.acceptMediaType = acceptMediaType;
        return this;
    }

    public ResourceBuilder contentMediaType(String contentMediaType) {
        this.contentMediaType = contentMediaType;
        return this;
    }

    public Resource build() {
        ClientApplication clientApplication = new ClientApplication();
        clientApplication.setSingletons(Collections.singleton(new JacksonJsonProvider()));
        ClientConfig config = new ClientConfig().applications(new Application[]{clientApplication});
        BasicAuthSecurityHandler basicAuthHandler = new BasicAuthSecurityHandler();
        basicAuthHandler.setUserName(this.username);
        basicAuthHandler.setPassword(this.password);
        config.handlers(new ClientHandler[]{basicAuthHandler});
        RestClient restClient = new RestClient(config);
        String resourceUrl = this.baseUrl + REST_PATH + this.resourceName;
        Resource resource = restClient.resource(resourceUrl);
        resource.accept(new String[]{this.acceptMediaType});
        resource.contentType(this.contentMediaType);
        return resource;
    }
}

