/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.SettingsBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSettingsResourceFuncTest {
    @Test
    public void testGetSettings() {
        Resource settingsResource = ResourceBuilder.builder("settings").build();
        ClientResponse clientResponse = settingsResource.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
        Assert.assertNotNull((Object)((SettingsBean)clientResponse.getEntity(SettingsBean.class)).getTitle());
    }

    @Test
    public void testSetSettings() {
        Resource settingsResource = ResourceBuilder.builder("settings").build();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)settingsResource.put((Object)this.getExampleBean()).getStatusCode());
        ClientResponse clientResponse = settingsResource.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
        Assert.assertEquals((Object)this.getExampleBean(), (Object)clientResponse.getEntity(SettingsBean.class));
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testGetSettingsUnauthenticated() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("wrong").password("password").build();
        settingsResource.get();
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testSetSettingsUnauthenticated() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("wrong").password("password").build();
        settingsResource.put((Object)this.getExampleBean());
    }

    @Test
    public void testGetSettingsUnauthorized() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("user").password("user").build();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)settingsResource.get().getStatusCode());
    }

    @Test
    public void testSetSettingsUnauthorized() {
        Resource settingsResource = ResourceBuilder.builder("settings").username("user").password("user").build();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)settingsResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    protected SettingsBean getExampleBean() {
        return SettingsBean.EXAMPLE_1;
    }
}

