/*
 * Decompiled with CFR 0.152.
 */
package it.de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.MailServerSmtpBean;
import it.de.aservo.confapi.commons.rest.ResourceBuilder;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMailServerSmtpResourceFuncTest {
    @Test
    public void testGetMailserverImap() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").build();
        ClientResponse clientResponse = mailserverResource.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
        MailServerSmtpBean mailServerSmtpBean = (MailServerSmtpBean)clientResponse.getEntity(MailServerSmtpBean.class);
        Assert.assertNotNull((Object)mailServerSmtpBean);
    }

    @Test
    public void testSetMailserverImap() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").build();
        ClientResponse clientResponse = mailserverResource.put((Object)this.getExampleBean());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)clientResponse.getStatusCode());
        MailServerSmtpBean mailServerSmtpBean = (MailServerSmtpBean)clientResponse.getEntity(MailServerSmtpBean.class);
        this.assertMailserverBeanAgainstExample(mailServerSmtpBean);
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testGetMailserverImapUnauthenticated() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("wrong").password("password").build();
        mailserverResource.get();
    }

    @Test(expected=ClientAuthenticationException.class)
    public void testSetMailserverImapUnauthenticated() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("wrong").password("password").build();
        mailserverResource.put((Object)this.getExampleBean());
    }

    @Test
    public void testGetMailserverImapUnauthorized() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("user").password("user").build();
        mailserverResource.get();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)mailserverResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    @Test
    public void testSetMailserverImapUnauthorized() {
        Resource mailserverResource = ResourceBuilder.builder("mail-server/smtp").username("user").password("user").build();
        mailserverResource.put((Object)this.getExampleBean());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)mailserverResource.put((Object)this.getExampleBean()).getStatusCode());
    }

    protected void assertMailserverBeanAgainstExample(MailServerSmtpBean bean) {
        MailServerSmtpBean exampleBean = this.getExampleBean();
        exampleBean.setPassword(null);
        Assert.assertEquals((Object)exampleBean, (Object)bean);
    }

    protected MailServerSmtpBean getExampleBean() {
        return MailServerSmtpBean.EXAMPLE_2;
    }
}

