/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.util;

import de.aservo.confapi.commons.util.ConversionUtil;
import org.junit.Assert;
import org.junit.Test;

public class ConversionUtilTest {
    @Test
    public void testConvertLong() {
        Assert.assertEquals((long)0L, (long)ConversionUtil.toLong(null));
        Assert.assertEquals((long)0L, (long)ConversionUtil.toLong((String)""));
        Assert.assertEquals((long)100L, (long)ConversionUtil.toLong((String)"100"));
        Assert.assertEquals((long)234234234234234L, (long)ConversionUtil.toLong((String)"234234234234234"));
    }

    @Test
    public void testConvertInt() {
        Assert.assertEquals((long)0L, (long)ConversionUtil.toInt(null));
        Assert.assertEquals((long)0L, (long)ConversionUtil.toInt((String)""));
        Assert.assertEquals((long)100L, (long)ConversionUtil.toInt((String)"100"));
    }

    @Test
    public void testConvertDouble() {
        Assert.assertEquals((double)0.0, (double)ConversionUtil.toDouble(null), (double)0.0);
        Assert.assertEquals((double)0.0, (double)ConversionUtil.toDouble((String)""), (double)0.0);
        Assert.assertEquals((double)100.0, (double)ConversionUtil.toDouble((String)"100"), (double)0.0);
        Assert.assertEquals((double)100.1231234, (double)ConversionUtil.toDouble((String)"100.1231234"), (double)0.0);
    }

    @Test
    public void testConvertBoolean() {
        Assert.assertFalse((boolean)ConversionUtil.toBoolean(null));
        Assert.assertFalse((boolean)ConversionUtil.toBoolean((String)""));
        Assert.assertFalse((boolean)ConversionUtil.toBoolean((String)"false"));
        Assert.assertFalse((boolean)ConversionUtil.toBoolean((String)"False"));
        Assert.assertFalse((boolean)ConversionUtil.toBoolean((String)"no"));
        Assert.assertFalse((boolean)ConversionUtil.toBoolean((String)"0"));
        Assert.assertTrue((boolean)ConversionUtil.toBoolean((String)"1"));
        Assert.assertTrue((boolean)ConversionUtil.toBoolean((String)"true"));
        Assert.assertTrue((boolean)ConversionUtil.toBoolean((String)"TRUE"));
        Assert.assertTrue((boolean)ConversionUtil.toBoolean((String)"yes"));
        Assert.assertTrue((boolean)ConversionUtil.toBoolean((String)"ja"));
    }
}

