/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.SettingsBrandingColorSchemeBean;
import de.aservo.confapi.commons.rest.TestSettingsBrandingResourceImpl;
import de.aservo.confapi.commons.service.api.SettingsBrandingService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractSettingsBrandingResourceTest {
    @Mock
    private SettingsBrandingService brandingService;
    private TestSettingsBrandingResourceImpl resource;

    @Before
    public void setup() {
        this.resource = new TestSettingsBrandingResourceImpl(this.brandingService);
    }

    @Test
    public void testGetColourScheme() {
        SettingsBrandingColorSchemeBean bean = SettingsBrandingColorSchemeBean.EXAMPLE_1;
        ((SettingsBrandingService)Mockito.doReturn((Object)bean).when((Object)this.brandingService)).getColourScheme();
        Response response = this.resource.getBrandingColorScheme();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        SettingsBrandingColorSchemeBean colourSchemeBean = (SettingsBrandingColorSchemeBean)response.getEntity();
        Assert.assertEquals((Object)colourSchemeBean, (Object)bean);
    }

    @Test
    public void testSetColourScheme() {
        SettingsBrandingColorSchemeBean bean = SettingsBrandingColorSchemeBean.EXAMPLE_1;
        ((SettingsBrandingService)Mockito.doReturn((Object)bean).when((Object)this.brandingService)).setColourScheme(bean);
        Response response = this.resource.setBrandingColorScheme(bean);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        SettingsBrandingColorSchemeBean colourSchemeBean = (SettingsBrandingColorSchemeBean)response.getEntity();
        Assert.assertEquals((Object)colourSchemeBean, (Object)bean);
    }

    @Test
    public void testGetLogo() {
        InputStream stream = this.createDummyInputStream();
        ((SettingsBrandingService)Mockito.doReturn((Object)stream).when((Object)this.brandingService)).getLogo();
        Response response = this.resource.getBrandingLogo();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        InputStream inputStream = (InputStream)response.getEntity();
        Assert.assertNotNull((Object)inputStream);
    }

    @Test
    public void testSetLogo() {
        InputStream stream = this.createDummyInputStream();
        Response response = this.resource.setBrandingLogo(stream);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetFavicon() {
        InputStream stream = this.createDummyInputStream();
        ((SettingsBrandingService)Mockito.doReturn((Object)stream).when((Object)this.brandingService)).getFavicon();
        Response response = this.resource.getBrandingFavicon();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        InputStream inputStream = (InputStream)response.getEntity();
        Assert.assertNotNull((Object)inputStream);
    }

    @Test
    public void testSetFavicon() {
        InputStream stream = this.createDummyInputStream();
        Response response = this.resource.setBrandingFavicon(stream);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    private InputStream createDummyInputStream() {
        return new ByteArrayInputStream("TEST-STREAM".getBytes());
    }
}

