/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoriesBean;
import de.aservo.confapi.commons.model.DirectoryCrowdBean;
import de.aservo.confapi.commons.rest.TestDirectoriesResourceImpl;
import de.aservo.confapi.commons.service.api.DirectoriesService;
import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractDirectoriesResourceTest {
    @Mock
    private DirectoriesService directoriesService;
    private TestDirectoriesResourceImpl resource;

    @Before
    public void setup() {
        this.resource = new TestDirectoriesResourceImpl(this.directoriesService);
    }

    @Test
    public void testGetDirectories() {
        DirectoryCrowdBean initialDirectoryBean = DirectoryCrowdBean.EXAMPLE_1;
        DirectoriesBean directoriesBean = new DirectoriesBean(Collections.singleton(initialDirectoryBean));
        ((DirectoriesService)Mockito.doReturn((Object)directoriesBean).when((Object)this.directoriesService)).getDirectories();
        Response response = this.resource.getDirectories();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        DirectoriesBean directoriesBeanResponse = (DirectoriesBean)response.getEntity();
        Assert.assertEquals((Object)initialDirectoryBean, directoriesBeanResponse.getDirectories().iterator().next());
    }

    @Test
    public void testGetDirectory() {
        DirectoryCrowdBean directoryBean = DirectoryCrowdBean.EXAMPLE_1;
        ((DirectoriesService)Mockito.doReturn((Object)directoryBean).when((Object)this.directoriesService)).getDirectory(1L);
        Response response = this.resource.getDirectory(1L);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AbstractDirectoryBean directoryBeanResponse = (AbstractDirectoryBean)response.getEntity();
        Assert.assertEquals((Object)directoryBean, (Object)directoryBeanResponse);
    }

    @Test
    public void testSetDirectories() {
        DirectoryCrowdBean directoryBean1 = DirectoryCrowdBean.EXAMPLE_1;
        DirectoryCrowdBean directoryBean2 = DirectoryCrowdBean.EXAMPLE_3;
        DirectoriesBean directoriesBean = new DirectoriesBean(Arrays.asList(directoryBean1, directoryBean2));
        ((DirectoriesService)Mockito.doReturn((Object)directoriesBean).when((Object)this.directoriesService)).setDirectories(directoriesBean, false);
        Response response = this.resource.setDirectories(Boolean.FALSE, directoriesBean);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        DirectoriesBean directoriesBeanResponse = (DirectoriesBean)response.getEntity();
        Assert.assertEquals((long)directoriesBean.getDirectories().size(), (long)directoriesBeanResponse.getDirectories().size());
    }

    @Test
    public void testSetDirectory() {
        DirectoryCrowdBean directoryBean = DirectoryCrowdBean.EXAMPLE_1;
        ((DirectoriesService)Mockito.doReturn((Object)directoryBean).when((Object)this.directoriesService)).setDirectory(1L, (AbstractDirectoryBean)directoryBean, false);
        Response response = this.resource.setDirectory(1L, Boolean.FALSE, (AbstractDirectoryBean)directoryBean);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AbstractDirectoryBean directoryBeanResponse = (AbstractDirectoryBean)response.getEntity();
        Assert.assertEquals((Object)directoryBean, (Object)directoryBeanResponse);
    }

    @Test
    public void testAddDirectory() {
        DirectoryCrowdBean bean = DirectoryCrowdBean.EXAMPLE_1;
        ((DirectoriesService)Mockito.doReturn((Object)bean).when((Object)this.directoriesService)).addDirectory((AbstractDirectoryBean)bean, false);
        Response response = this.resource.addDirectory(Boolean.FALSE, (AbstractDirectoryBean)bean);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AbstractDirectoryBean responseBean = (AbstractDirectoryBean)response.getEntity();
        Assert.assertEquals((Object)bean.getName(), (Object)responseBean.getName());
    }

    @Test
    public void testDeleteDirectories() {
        this.resource.deleteDirectories(true);
        Assert.assertTrue((String)"Delete Successful", (boolean)true);
    }

    @Test
    public void testDeleteDirectory() {
        this.resource.deleteDirectory(1L);
        Assert.assertTrue((String)"Delete Successful", (boolean)true);
    }
}

