/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.model;

import de.aservo.confapi.commons.model.ErrorCollection;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ErrorCollectionTest {
    public static final String FIRST_ERROR_MESSAGE = "First error message";
    public static final String SECOND_ERROR_MESSAGE = "Second error message";
    private ErrorCollection errorCollection;

    @Before
    public void setup() {
        this.errorCollection = new ErrorCollection();
    }

    @Test
    public void testDefaultConstructor() {
        Assert.assertFalse((boolean)this.errorCollection.hasAnyErrors());
    }

    @Test
    public void testAddErrorMessage() {
        this.errorCollection.addErrorMessage(FIRST_ERROR_MESSAGE);
        Assert.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assert.assertThat((Object)this.errorCollection.getErrorMessages().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.errorCollection.getErrorMessages(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{FIRST_ERROR_MESSAGE}));
    }

    @Test
    public void testAddNullErrorMessage() {
        this.errorCollection.addErrorMessage(null);
        Assert.assertFalse((boolean)this.errorCollection.hasAnyErrors());
    }

    @Test
    public void testAddErrorMessageList() {
        this.errorCollection.addErrorMessages(Arrays.asList(FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE));
        Assert.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assert.assertThat((Object)this.errorCollection.getErrorMessages().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.errorCollection.getErrorMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE}));
    }

    @Test
    public void testAddNullErrorMessageList() {
        this.errorCollection.addErrorMessages(null);
        Assert.assertFalse((boolean)this.errorCollection.hasAnyErrors());
    }

    @Test
    public void testOfErrorMessages() {
        this.errorCollection = ErrorCollection.of((String[])new String[]{FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE});
        Assert.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assert.assertThat((Object)this.errorCollection.getErrorMessages().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.errorCollection.getErrorMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE}));
    }

    @Test
    public void testOfErrorMessageList() {
        this.errorCollection = ErrorCollection.of(Arrays.asList(FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE));
        Assert.assertTrue((boolean)this.errorCollection.hasAnyErrors());
        Assert.assertThat((Object)this.errorCollection.getErrorMessages().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.errorCollection.getErrorMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{FIRST_ERROR_MESSAGE, SECOND_ERROR_MESSAGE}));
    }
}

