/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.junit;

import com.google.common.base.CaseFormat;
import de.aservo.confapi.commons.junit.AbstractTest;
import javax.xml.bind.annotation.XmlRootElement;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractBeanTest
extends AbstractTest {
    private static final String CLASS_SUFFIX = "Bean";

    @Test
    public void beanClassNameShouldEndWithSuffixBean() {
        String beanClassName = this.getBaseClass().getSimpleName();
        Assert.assertTrue((String)"The model class name should end with suffix Bean", (boolean)beanClassName.endsWith(CLASS_SUFFIX));
    }

    @Test
    public void beanClassNameAndXmlRootElementShouldMatch() {
        String beanClassName = this.getBaseClass().getSimpleName();
        String beanClassBaseName = beanClassName.substring(0, beanClassName.length() - CLASS_SUFFIX.length());
        XmlRootElement xmlRootElement = this.getBaseClass().getAnnotation(XmlRootElement.class);
        Assert.assertNotNull((Object)xmlRootElement);
        Assert.assertEquals((String)"The model class camel-case base name and the xml root element kebab-case base name should match", (Object)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, beanClassBaseName), (Object)xmlRootElement.name());
    }
}

