/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.core.api.functions;

@FunctionalInterface
public interface Interpolation {
    public static final Interpolation LINEAR = (x, a, b) -> a + x * (b - a);
    public static final Interpolation QUADRATIC = (x, a, b) -> a + (b - a) * x * x;
    public static final Interpolation CUBIC = (x, a, b) -> a + (b - a) * x * x * x;
    public static final Interpolation QUARTIC = (x, a, b) -> a + (b - a) * x * x * x * x;
    public static final Interpolation COSINE = (x, a, b) -> a + (1.0 - Math.cos(x * Math.PI)) / 2.0 * (b - a);

    public double lerp(double var1, double var3, double var5);

    default public double lerp(double[] positions, double[] values) {
        if (values.length != 1 << positions.length) {
            throw new IllegalArgumentException("The amount of values must be 2^(amount of fractals).");
        }
        for (int i = 0; i < positions.length; ++i) {
            for (int j = 0; j < (1 << positions.length) - i; j += 2) {
                values[j / 2] = this.lerp(positions[i], values[j], values[j + 1]);
            }
        }
        return values[0];
    }
}

