/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.atomic.AtomicReference;

public class IntervalChecker {
    final Duration intervalDuration;
    final AtomicReference<Instant> lastCheck = new AtomicReference<Object>(null);
    Runnable taskOnDue = null;
    Runnable taskOnNotDue = null;

    public static IntervalChecker every(long amount, TemporalUnit unit) {
        return IntervalChecker.every(Duration.of(amount, unit));
    }

    public static IntervalChecker every(Duration duration) {
        if (duration.isPositive()) {
            return new IntervalChecker(duration);
        }
        throw new IllegalArgumentException("Amount of interval must be > 0");
    }

    private IntervalChecker(Duration intervalDuration) {
        this.intervalDuration = intervalDuration;
    }

    boolean isDue(Instant checkTime) {
        return checkTime == null || checkTime.plus(this.intervalDuration).isBefore(Instant.now());
    }

    public boolean update() {
        Instant checkTime;
        boolean due;
        while ((due = this.isDue(checkTime = this.lastCheck.get())) && !this.lastCheck.compareAndSet(checkTime, Instant.now())) {
        }
        return due;
    }

    public boolean executeTasks(Runnable onDue, Runnable onNotDue) {
        if (this.update()) {
            if (onDue != null) {
                onDue.run();
            }
            return true;
        }
        if (onNotDue != null) {
            onNotDue.run();
        }
        return false;
    }

    public boolean execute() {
        return this.executeTasks(this.taskOnDue, this.taskOnNotDue);
    }

    public IntervalChecker whenDue(Runnable task) {
        this.taskOnDue = task;
        return this;
    }

    public IntervalChecker whenNotDue(Runnable task) {
        this.taskOnNotDue = task;
        return this;
    }

    public boolean executeIfDue() {
        return this.executeTaskIfDue(this.taskOnDue);
    }

    public boolean executeTaskIfDue(Runnable task) {
        return this.executeTasks(task, null);
    }

    public boolean executeIfNotDue() {
        return this.executeTaskIfNotDue(this.taskOnNotDue);
    }

    public boolean executeTaskIfNotDue(Runnable task) {
        return this.executeTasks(null, task);
    }

    public boolean isDue() {
        return this.isDue(this.lastCheck.get());
    }

    public IntervalChecker restartTimer() {
        this.lastCheck.set(Instant.now());
        return this;
    }

    public IntervalChecker forceDue() {
        this.lastCheck.set(null);
        return this;
    }
}

