/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil;

import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;

public class Guarded<T> {
    final T target;
    final Lock lock;

    public Guarded(T target, boolean fair) {
        this.target = target;
        this.lock = new ReentrantLock(fair);
    }

    public Guarded(T target) {
        this(target, false);
    }

    public void access(Consumer<T> action) {
        this.lock.lock();
        try {
            action.accept(this.target);
        }
        finally {
            this.lock.unlock();
        }
    }

    public <R> R process(Function<T, R> action) {
        this.lock.lock();
        try {
            R r = action.apply(this.target);
            return r;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean tryAccess(Consumer<T> action) {
        if (this.lock.tryLock()) {
            try {
                action.accept(this.target);
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public <R> Optional<R> tryProcess(Function<T, R> action) {
        if (this.lock.tryLock()) {
            try {
                Optional<R> optional = Optional.ofNullable(action.apply(this.target));
                return optional;
            }
            finally {
                this.lock.unlock();
            }
        }
        return Optional.empty();
    }
}

