/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.atomic.AtomicReference;

public class IntervalChecker {
    final Duration intervalDuration;
    final AtomicReference<Instant> lastCheck = new AtomicReference<Object>(null);

    public static IntervalChecker every(long amount, TemporalUnit unit) {
        if (amount > 0L) {
            return new IntervalChecker(Duration.of(amount, unit));
        }
        throw new IllegalArgumentException("Amount of interval must be > 0");
    }

    private IntervalChecker(Duration intervalDuration) {
        this.intervalDuration = intervalDuration;
    }

    boolean isDue(Instant checkTime) {
        return checkTime == null || checkTime.plus(this.intervalDuration).isBefore(Instant.now());
    }

    public boolean updateIfDue() {
        Instant checkTime;
        while (this.isDue(checkTime = this.lastCheck.get()) && !this.lastCheck.compareAndSet(checkTime, Instant.now())) {
        }
        return this.isDue(checkTime);
    }

    public boolean executeIfDue(Runnable task) {
        if (this.updateIfDue()) {
            task.run();
            return true;
        }
        return false;
    }

    public void forceChecked() {
        this.lastCheck.set(Instant.now());
    }

    public void forceDue() {
        this.lastCheck.set(null);
    }
}

