/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil.math;

import de.arstwo.twotil.math.MathUtil;
import de.arstwo.twotil.math.Vector4f;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class Matrix4f
implements Cloneable {
    public static final int ROWS = 4;
    public static final int COLS = 4;
    public static final int LENGTH = 16;
    public static final int SIZE_BYTE = 64;
    private static final float[] IDENTITY_DATA = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    protected static final Matrix4f IDENTITY = new Matrix4f().setIdentity();
    private static final float[] ZERO_DATA = new float[16];
    public static final int XX = 0;
    public static final int YX = 1;
    public static final int ZX = 2;
    public static final int WX = 3;
    public static final int XY = 4;
    public static final int YY = 5;
    public static final int ZY = 6;
    public static final int WY = 7;
    public static final int XZ = 8;
    public static final int YZ = 9;
    public static final int ZZ = 10;
    public static final int WZ = 11;
    public static final int XW = 12;
    public static final int YW = 13;
    public static final int ZW = 14;
    public static final int WW = 15;
    protected final FloatBuffer buffer = FloatBuffer.allocate(16);
    protected final float[] data = this.buffer.array();

    public static Matrix4f getIdentityMatrix() {
        return IDENTITY.clone();
    }

    public Matrix4f() {
        if (this.data == null || this.data.length != 16) {
            throw new UnsupportedOperationException("FloatBuffer did not provide an underlying array.");
        }
    }

    public Matrix4f set(Matrix4f other) {
        assert (this != other) : "Trying to set Matrix to itself";
        return this.setUnchecked(other.data);
    }

    public Matrix4f setColumnMajor(float[] data) {
        if (data == null) {
            throw new NullPointerException("Matrix4f data must not be null.");
        }
        if (data.length != this.data.length) {
            throw new IllegalArgumentException("Array length must be equal to the size of Matrix4f data.");
        }
        return this.setUnchecked(data);
    }

    public Matrix4f setRowMajor(float[] data) {
        if (data == null) {
            throw new NullPointerException("Matrix4f data must not be null.");
        }
        if (data.length != this.data.length) {
            throw new IllegalArgumentException("Array length must be equal to the size of Matrix4f data.");
        }
        int i = -1;
        this.data[0] = data[++i];
        this.data[4] = data[++i];
        this.data[8] = data[++i];
        this.data[12] = data[++i];
        this.data[1] = data[++i];
        this.data[5] = data[++i];
        this.data[9] = data[++i];
        this.data[13] = data[++i];
        this.data[2] = data[++i];
        this.data[6] = data[++i];
        this.data[10] = data[++i];
        this.data[14] = data[++i];
        this.data[3] = data[++i];
        this.data[7] = data[++i];
        this.data[11] = data[++i];
        this.data[15] = data[++i];
        return this;
    }

    public Matrix4f setZero() {
        return this.setUnchecked(ZERO_DATA);
    }

    protected Matrix4f setUnchecked(float[] data) {
        System.arraycopy(data, 0, this.data, 0, 16);
        return this;
    }

    public Matrix4f setIdentity() {
        return this.setUnchecked(IDENTITY_DATA);
    }

    public Matrix4f setTranspose() {
        float h = this.data[1];
        this.data[1] = this.data[4];
        this.data[4] = h;
        h = this.data[2];
        this.data[2] = this.data[8];
        this.data[8] = h;
        h = this.data[3];
        this.data[3] = this.data[12];
        this.data[12] = h;
        h = this.data[6];
        this.data[6] = this.data[9];
        this.data[9] = h;
        h = this.data[7];
        this.data[7] = this.data[13];
        this.data[13] = h;
        h = this.data[11];
        this.data[11] = this.data[14];
        this.data[14] = h;
        return this;
    }

    public Matrix4f setOrthogonalProjection() {
        this.setIdentity();
        this.data[10] = -1.0f;
        return this;
    }

    public Matrix4f setProjection(float fovY, float aspectRatio, float zNear, float zFar) {
        this.setIdentity();
        float radians = fovY / 2.0f * (float)Math.PI / 180.0f;
        float deltaZ = zFar - zNear;
        float sine = (float)Math.sin(radians);
        if (deltaZ == 0.0f || sine == 0.0f || aspectRatio == 0.0f) {
            return this;
        }
        float cotangent = (float)Math.cos(radians) / sine;
        this.data[0] = cotangent / aspectRatio;
        this.data[5] = cotangent;
        this.data[10] = -(zFar + zNear) / deltaZ;
        this.data[11] = -1.0f;
        this.data[14] = -2.0f * zNear * zFar / deltaZ;
        this.data[15] = 0.0f;
        return this;
    }

    public Matrix4f setLook(Vector4f position, Vector4f right, Vector4f up, Vector4f look) {
        return this.setLook(position.data[0], position.data[1], position.data[2], right.data[0], right.data[1], right.data[2], up.data[0], up.data[1], up.data[2], look.data[0], look.data[1], look.data[2]);
    }

    public Matrix4f setLook(float positionX, float positionY, float positionZ, float rightX, float rightY, float rightZ, float upX, float upY, float upZ, float lookX, float lookY, float lookZ) {
        this.data[0] = rightX;
        this.data[4] = rightY;
        this.data[8] = rightZ;
        this.data[12] = -positionX;
        this.data[1] = upX;
        this.data[5] = upY;
        this.data[9] = upZ;
        this.data[13] = -positionY;
        this.data[2] = lookX;
        this.data[6] = lookY;
        this.data[10] = lookZ;
        this.data[14] = -positionZ;
        this.data[3] = 0.0f;
        this.data[7] = 0.0f;
        this.data[11] = 0.0f;
        this.data[15] = 1.0f;
        return this;
    }

    public Matrix4f add(Matrix4f other) {
        float[] thisData = this.data;
        float[] otherData = other.data;
        for (int i = 15; i >= 0; --i) {
            int n = i;
            thisData[n] = thisData[n] + otherData[i];
        }
        return this;
    }

    public Matrix4f sub(Matrix4f other) {
        float[] thisData = this.data;
        float[] otherData = other.data;
        for (int i = 15; i >= 0; --i) {
            int n = i;
            thisData[n] = thisData[n] - otherData[i];
        }
        return this;
    }

    public Matrix4f multiply(Matrix4f other) {
        float[] result = new float[16];
        float[] thisData = this.data;
        float[] otherData = other.data;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                result[col * 4 + row] = thisData[0 + row] * otherData[col * 4] + thisData[4 + row] * otherData[col * 4 + 1] + thisData[8 + row] * otherData[col * 4 + 2] + thisData[12 + row] * otherData[col * 4 + 3];
            }
        }
        System.arraycopy(result, 0, this.data, 0, result.length);
        return this;
    }

    public Matrix4f setTranslate(float x, float y, float z) {
        this.data[12] = x;
        this.data[13] = y;
        this.data[14] = z;
        return this;
    }

    public Matrix4f translate(Matrix4f other) {
        this.data[12] = this.data[12] + other.data[12];
        this.data[13] = this.data[13] + other.data[13];
        this.data[14] = this.data[14] + other.data[14];
        return this;
    }

    public Matrix4f translate(float x, float y, float z) {
        this.data[12] = this.data[12] + x;
        this.data[13] = this.data[13] + y;
        this.data[14] = this.data[14] + z;
        return this;
    }

    public Matrix4f translate(Vector4f direction) {
        this.data[12] = this.data[12] + direction.data[0];
        this.data[13] = this.data[13] + direction.data[1];
        this.data[14] = this.data[14] + direction.data[2];
        return this;
    }

    public Matrix4f translateX(float x) {
        this.data[12] = this.data[12] + x;
        return this;
    }

    public Matrix4f translateY(float y) {
        this.data[13] = this.data[13] + y;
        return this;
    }

    public Matrix4f translateZ(float z) {
        this.data[14] = this.data[14] + z;
        return this;
    }

    public Matrix4f rotate(float radians, Vector4f axis) {
        return this.rotate(radians, axis.data[0], axis.data[1], axis.data[2]);
    }

    public Matrix4f rotate(float radians, float axisX, float axisY, float axisZ) {
        Matrix4f other = new Matrix4f().setRotation(radians, axisX, axisY, axisZ);
        return this.multiply(other);
    }

    public Matrix4f setRotation(float radians, Vector4f axis) {
        return this.setRotation(radians, axis.data[0], axis.data[1], axis.data[2]);
    }

    public Matrix4f setRotation(float radians, float axisX, float axisY, float axisZ) {
        double radiansHalf = (double)radians / 2.0;
        float q0 = (float)Math.cos(radiansHalf);
        float sinRadiansHalf = (float)Math.sin(radiansHalf);
        float q1 = sinRadiansHalf * axisX;
        float q2 = sinRadiansHalf * axisY;
        float q3 = sinRadiansHalf * axisZ;
        float q0Squared = q0 * q0;
        float q1Squared = q1 * q1;
        float q2Squared = q2 * q2;
        float q3Squared = q3 * q3;
        this.data[0] = q0Squared + q1Squared - q2Squared - q3Squared;
        this.data[4] = 2.0f * (q1 * q2 - q0 * q3);
        this.data[8] = 2.0f * (q1 * q3 + q0 * q2);
        this.data[12] = 0.0f;
        this.data[1] = 2.0f * (q2 * q1 + q0 * q3);
        this.data[5] = q0Squared - q1Squared + q2Squared - q3Squared;
        this.data[9] = 2.0f * (q2 * q3 - q0 * q1);
        this.data[13] = 0.0f;
        this.data[2] = 2.0f * (q3 * q1 - q0 * q2);
        this.data[6] = 2.0f * (q3 * q2 + q0 * q1);
        this.data[10] = q0Squared - q1Squared - q2Squared + q3Squared;
        this.data[14] = 0.0f;
        this.data[3] = 0.0f;
        this.data[7] = 0.0f;
        this.data[11] = 0.0f;
        this.data[15] = 1.0f;
        return this;
    }

    public FloatBuffer buffer() {
        return this.buffer;
    }

    public int hashCode() {
        return 71 + Arrays.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((Matrix4f)obj);
    }

    public boolean equals(Matrix4f other) {
        if (other == null) {
            return false;
        }
        for (int i = 15; i >= 0; --i) {
            if (Float.floatToIntBits(this.data[i]) == Float.floatToIntBits(other.data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Matrix4f other, float delta) {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if (MathUtil.aboutEqual(this.data[i], other.data[i], delta)) continue;
            return false;
        }
        return true;
    }

    public Matrix4f clone() {
        return new Matrix4f().setUnchecked(this.data);
    }

    public String toString() {
        return String.format("%n|%7.3f %7.3f %7.3f %7.3f|%n|%7.3f %7.3f %7.3f %7.3f|%n|%7.3f %7.3f %7.3f %7.3f|%n|%7.3f %7.3f %7.3f %7.3f|%n", Float.valueOf(this.data[0]), Float.valueOf(this.data[4]), Float.valueOf(this.data[8]), Float.valueOf(this.data[12]), Float.valueOf(this.data[1]), Float.valueOf(this.data[5]), Float.valueOf(this.data[9]), Float.valueOf(this.data[13]), Float.valueOf(this.data[2]), Float.valueOf(this.data[6]), Float.valueOf(this.data[10]), Float.valueOf(this.data[14]), Float.valueOf(this.data[3]), Float.valueOf(this.data[7]), Float.valueOf(this.data[11]), Float.valueOf(this.data[15]));
    }
}

