/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static Predicate<Path> fileOlderThan(long amountToSubtract, TemporalUnit unit) {
        Instant compareInstant = Instant.now().minus(amountToSubtract, unit);
        return p -> {
            try {
                return Files.getLastModifiedTime(p, new LinkOption[0]).toInstant().isBefore(compareInstant);
            }
            catch (IOException e) {
                return false;
            }
        };
    }

    public static boolean unzipRootOnly(Path source, Path targetDir) {
        boolean bl;
        ZipInputStream zis = new ZipInputStream(Files.newInputStream(source, new OpenOption[0]));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    Path target = targetDir.resolve(zipEntry.getName());
                    Files.copy(zis, target, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        zis.close();
        return bl;
    }

    public static boolean tryDeletePath(Path p) {
        try {
            Files.deleteIfExists(p);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private FileUtil() {
    }
}

