/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil.math;

import de.arstwo.twotil.math.Matrix4f;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class Vector4f
implements Cloneable {
    protected final FloatBuffer buffer = FloatBuffer.allocate(4);
    protected final float[] data = this.buffer.array();
    public static final int LENGTH = 4;
    public static final int SIZE_BYTE = 16;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int W = 3;

    public Vector4f() {
        if (this.data == null || this.data.length != 4) {
            throw new UnsupportedOperationException("FloatBuffer did not provide an underlying array.");
        }
    }

    public Vector4f(float x, float y, float z, boolean isPosition) {
        this();
        this.data[0] = x;
        this.data[1] = y;
        this.data[2] = z;
        this.data[3] = isPosition ? 1.0f : 0.0f;
    }

    public Vector4f set(Vector4f other) {
        return this.setUnchecked(other.data);
    }

    public Vector4f set(float x, float y, float z) {
        this.data[0] = x;
        this.data[1] = y;
        this.data[2] = z;
        return this;
    }

    public Vector4f setX(float x) {
        this.data[0] = x;
        return this;
    }

    public Vector4f setY(float y) {
        this.data[1] = y;
        return this;
    }

    public Vector4f setZ(float z) {
        this.data[2] = z;
        return this;
    }

    public Vector4f set(float[] data) {
        if (data == null) {
            throw new NullPointerException("Vector4f data must not be null.");
        }
        if (data.length != this.data.length) {
            throw new IllegalArgumentException("Array length must be equal to the size of Vector4f data.");
        }
        return this.setUnchecked(data);
    }

    protected Vector4f setUnchecked(float[] data) {
        System.arraycopy(data, 0, this.data, 0, 4);
        return this;
    }

    public Vector4f setZero() {
        this.data[0] = 0.0f;
        this.data[1] = 0.0f;
        this.data[2] = 0.0f;
        return this;
    }

    public Vector4f setZeroPosition() {
        this.data[0] = 0.0f;
        this.data[1] = 0.0f;
        this.data[2] = 0.0f;
        this.data[3] = 1.0f;
        return this;
    }

    public Vector4f setZeroDirection() {
        this.data[0] = 0.0f;
        this.data[1] = 0.0f;
        this.data[2] = 0.0f;
        this.data[3] = 0.0f;
        return this;
    }

    public boolean isDirection() {
        return this.data[3] == 0.0f;
    }

    public boolean isPosition() {
        return this.data[3] == 1.0f;
    }

    public Vector4f setIsDirection() {
        this.data[3] = 0.0f;
        return this;
    }

    public Vector4f setIsPosition() {
        this.data[3] = 1.0f;
        return this;
    }

    public float lengthSquared() {
        float x = this.data[0];
        float y = this.data[1];
        float z = this.data[2];
        return x * x + y * y + z * z;
    }

    public float length() {
        double x = this.data[0];
        double y = this.data[1];
        double z = this.data[2];
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public Vector4f normalize() {
        float length = this.length();
        if (length == 0.0f) {
            throw new ArithmeticException("Cannot normalize vector with length equal to zero");
        }
        this.data[0] = this.data[0] / length;
        this.data[1] = this.data[1] / length;
        this.data[2] = this.data[2] / length;
        return this;
    }

    public Vector4f add(float x, float y, float z) {
        this.data[0] = this.data[0] + x;
        this.data[1] = this.data[1] + y;
        this.data[2] = this.data[2] + z;
        return this;
    }

    public Vector4f add(Vector4f other) {
        this.data[0] = this.data[0] + other.data[0];
        this.data[1] = this.data[1] + other.data[1];
        this.data[2] = this.data[2] + other.data[2];
        return this;
    }

    public Vector4f addX(float x) {
        this.data[0] = this.data[0] + x;
        return this;
    }

    public Vector4f addY(float y) {
        this.data[1] = this.data[1] + y;
        return this;
    }

    public Vector4f addZ(float z) {
        this.data[2] = this.data[2] + z;
        return this;
    }

    public Vector4f sub(float x, float y, float z) {
        this.data[0] = this.data[0] - x;
        this.data[1] = this.data[1] - y;
        this.data[2] = this.data[2] - z;
        return this;
    }

    public Vector4f sub(Vector4f other) {
        this.data[0] = this.data[0] - other.data[0];
        this.data[1] = this.data[1] - other.data[1];
        this.data[2] = this.data[2] - other.data[2];
        return this;
    }

    public Vector4f subX(float x) {
        this.data[0] = this.data[0] - x;
        return this;
    }

    public Vector4f subY(float y) {
        this.data[1] = this.data[1] - y;
        return this;
    }

    public Vector4f subZ(float z) {
        this.data[2] = this.data[2] - z;
        return this;
    }

    public Vector4f shear(float x, float y, float z) {
        this.data[0] = this.data[0] * x;
        this.data[1] = this.data[1] * y;
        this.data[2] = this.data[2] * z;
        return this;
    }

    public Vector4f shearX(float x) {
        this.data[0] = this.data[0] * x;
        return this;
    }

    public Vector4f shearY(float y) {
        this.data[1] = this.data[1] * y;
        return this;
    }

    public Vector4f shearZ(float z) {
        this.data[2] = this.data[2] * z;
        return this;
    }

    public Vector4f scale(float magnitude) {
        this.data[0] = this.data[0] * magnitude;
        this.data[1] = this.data[1] * magnitude;
        this.data[2] = this.data[2] * magnitude;
        return this;
    }

    public float dot(Vector4f other) {
        float result = this.data[0] * other.data[0];
        result += this.data[1] * other.data[1];
        return result += this.data[2] * other.data[2];
    }

    public Vector4f cross(Vector4f other) {
        float newX = this.data[1] * other.data[2] - this.data[2] * other.data[1];
        float newY = this.data[2] * other.data[0] - this.data[0] * other.data[2];
        this.data[2] = this.data[0] * other.data[1] - this.data[1] * other.data[0];
        this.data[0] = newX;
        this.data[1] = newY;
        return this;
    }

    public Vector4f transform(Matrix4f matrix) {
        float x = this.data[0];
        float y = this.data[1];
        float z = this.data[2];
        float w = this.data[3];
        this.data[0] = matrix.data[0] * x + matrix.data[4] * y + matrix.data[8] * z + matrix.data[12] * w;
        this.data[1] = matrix.data[1] * x + matrix.data[5] * y + matrix.data[9] * z + matrix.data[13] * w;
        this.data[2] = matrix.data[2] * x + matrix.data[6] * y + matrix.data[10] * z + matrix.data[14] * w;
        return this;
    }

    public Vector4f translate(Matrix4f matrix) {
        if (this.data[3] != 0.0f) {
            this.data[0] = this.data[0] + matrix.data[12];
            this.data[1] = this.data[1] + matrix.data[13];
            this.data[2] = this.data[2] + matrix.data[14];
        }
        return this;
    }

    public FloatBuffer buffer() {
        return this.buffer;
    }

    public float getX() {
        return this.data[0];
    }

    public float getY() {
        return this.data[1];
    }

    public float getZ() {
        return this.data[2];
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((Vector4f)obj);
    }

    public boolean equals(Vector4f other) {
        for (int i = 3; i >= 0; --i) {
            if (Float.floatToIntBits(this.data[i]) == Float.floatToIntBits(other.data[i])) continue;
            return false;
        }
        return true;
    }

    public Vector4f clone() {
        return new Vector4f().setUnchecked(this.data);
    }

    public String toString() {
        return "(" + this.data[0] + ", " + this.data[1] + ", " + this.data[2] + ", " + this.data[3] + ")";
    }
}

